/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sbdh;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.sbdh.PeppolSBDHAdditionalAttributes;
import com.helger.peppol.sbdh.payload.PeppolSBDHPayloadWriter;
import com.helger.peppol.sbdh.spec12.BinaryContentType;
import com.helger.peppol.sbdh.spec12.TextContentType;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NotThreadSafe
public class PeppolSBDHDocument {
    private final IIdentifierFactory m_aIdentifierFactory;
    private String m_sSenderScheme;
    private String m_sSenderValue;
    private String m_sReceiverScheme;
    private String m_sReceiverValue;
    private String m_sDocumentTypeScheme;
    private String m_sDocumentTypeValue;
    private String m_sProcessScheme;
    private String m_sProcessValue;
    private String m_sStandard;
    private String m_sTypeVersion;
    private String m_sType;
    private String m_sInstanceIdentifier;
    private LocalDateTime m_aCreationDateAndTime;
    private Element m_aBusinessMessage;
    private final StringMap m_aAdditionalAttrs = new StringMap();

    public PeppolSBDHDocument(@Nonnull IIdentifierFactory iIdentifierFactory) {
        this.m_aIdentifierFactory = (IIdentifierFactory)ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
    }

    @Nonnull
    public PeppolSBDHDocument setSender(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.m_sSenderScheme = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        this.m_sSenderValue = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        return this;
    }

    @Nonnull
    public PeppolSBDHDocument setSenderWithDefaultScheme(@Nonnull @Nonempty String string) {
        return this.setSender("iso6523-actorid-upis", string);
    }

    @Nullable
    public String getSenderScheme() {
        return this.m_sSenderScheme;
    }

    @Nullable
    public String getSenderValue() {
        return this.m_sSenderValue;
    }

    @Nullable
    public IParticipantIdentifier getSenderAsIdentifier() {
        return this.m_aIdentifierFactory.createParticipantIdentifier(this.m_sSenderScheme, this.m_sSenderValue);
    }

    @Nonnull
    public PeppolSBDHDocument setReceiver(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.m_sReceiverScheme = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        this.m_sReceiverValue = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        return this;
    }

    @Nonnull
    public PeppolSBDHDocument setReceiverWithDefaultScheme(@Nonnull @Nonempty String string) {
        return this.setReceiver("iso6523-actorid-upis", string);
    }

    @Nullable
    public String getReceiverScheme() {
        return this.m_sReceiverScheme;
    }

    @Nullable
    public String getReceiverValue() {
        return this.m_sReceiverValue;
    }

    @Nullable
    public IParticipantIdentifier getReceiverAsIdentifier() {
        return this.m_aIdentifierFactory.createParticipantIdentifier(this.m_sReceiverScheme, this.m_sReceiverValue);
    }

    @Nonnull
    public PeppolSBDHDocument setDocumentType(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.m_sDocumentTypeScheme = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        this.m_sDocumentTypeValue = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        return this;
    }

    @Nonnull
    public PeppolSBDHDocument setDocumentTypeWithDefaultScheme(@Nonnull @Nonempty String string) {
        return this.setDocumentType("busdox-docid-qns", string);
    }

    @Nullable
    public String getDocumentTypeScheme() {
        return this.m_sDocumentTypeScheme;
    }

    @Nullable
    public String getDocumentTypeValue() {
        return this.m_sDocumentTypeValue;
    }

    @Nullable
    public IDocumentTypeIdentifier getDocumentTypeAsIdentifier() {
        return this.m_aIdentifierFactory.createDocumentTypeIdentifier(this.m_sDocumentTypeScheme, this.m_sDocumentTypeValue);
    }

    @Nonnull
    public PeppolSBDHDocument setProcess(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.m_sProcessScheme = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        this.m_sProcessValue = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        return this;
    }

    @Nonnull
    public PeppolSBDHDocument setProcessWithDefaultScheme(@Nonnull @Nonempty String string) {
        return this.setProcess("cenbii-procid-ubl", string);
    }

    @Nullable
    public String getProcessScheme() {
        return this.m_sProcessScheme;
    }

    @Nullable
    public String getProcessValue() {
        return this.m_sProcessValue;
    }

    @Nullable
    public IProcessIdentifier getProcessAsIdentifier() {
        return this.m_aIdentifierFactory.createProcessIdentifier(this.m_sProcessScheme, this.m_sProcessValue);
    }

    @Nonnull
    @ReturnsMutableObject
    public StringMap additionalAttributes() {
        return this.m_aAdditionalAttrs;
    }

    @Nonnull
    public PeppolSBDHDocument setDocumentIdentification(@Nonnull String string, @Nonnull String string2, @Nonnull String string3, @Nonnull String string4, @Nonnull LocalDateTime localDateTime) {
        this.m_sStandard = (String)ValueEnforcer.notNull((Object)string, (String)"Standard");
        this.m_sTypeVersion = (String)ValueEnforcer.notNull((Object)string2, (String)"TypeVersion");
        this.m_sType = (String)ValueEnforcer.notNull((Object)string3, (String)"Type");
        this.m_sInstanceIdentifier = (String)ValueEnforcer.notNull((Object)string4, (String)"InstanceIdentifier");
        this.m_aCreationDateAndTime = (LocalDateTime)ValueEnforcer.notNull((Object)localDateTime, (String)"CreationDateAndTime");
        return this;
    }

    @Nullable
    public String getStandard() {
        return this.m_sStandard;
    }

    public boolean hasStandard() {
        return StringHelper.hasText((String)this.m_sStandard);
    }

    @Nullable
    public String getTypeVersion() {
        return this.m_sTypeVersion;
    }

    public boolean hasTypeVersion() {
        return StringHelper.hasText((String)this.m_sTypeVersion);
    }

    @Nullable
    public String getType() {
        return this.m_sType;
    }

    public boolean hasType() {
        return StringHelper.hasText((String)this.m_sType);
    }

    @Nullable
    public String getInstanceIdentifier() {
        return this.m_sInstanceIdentifier;
    }

    public boolean hasInstanceIdentifier() {
        return StringHelper.hasText((String)this.m_sInstanceIdentifier);
    }

    @Nullable
    public LocalDateTime getCreationDateAndTime() {
        return this.m_aCreationDateAndTime;
    }

    public boolean hasCreationDateAndTime() {
        return this.m_aCreationDateAndTime != null;
    }

    @Nonnull
    public PeppolSBDHDocument setBusinessMessage(@Nonnull Element element) {
        ValueEnforcer.notNull((Object)element, (String)"BusinessMessage");
        this.m_aBusinessMessage = (Element)element.cloneNode(true);
        return this;
    }

    @Nonnull
    public PeppolSBDHDocument setBusinessMessageBinaryOnly(@Nonnull byte[] byArray, @Nonnull IMimeType iMimeType, @Nullable Charset charset) {
        ValueEnforcer.notNull((Object)byArray, (String)"BinaryPayload");
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        BinaryContentType binaryContentType = new BinaryContentType();
        binaryContentType.setValue(byArray);
        binaryContentType.setMimeType(iMimeType.getAsString());
        binaryContentType.setEncoding(charset == null ? null : charset.name());
        Document document = PeppolSBDHPayloadWriter.binaryContent().getAsDocument(binaryContentType);
        if (document == null) {
            throw new IllegalStateException("Failed to create 'BinaryContent' element.");
        }
        this.m_aBusinessMessage = document.getDocumentElement();
        return this;
    }

    @Nonnull
    public PeppolSBDHDocument setBusinessMessageTextOnly(@Nonnull String string, @Nonnull IMimeType iMimeType) {
        ValueEnforcer.notNull((Object)string, (String)"TextPayload");
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        TextContentType textContentType = new TextContentType();
        textContentType.setValue(string);
        textContentType.setMimeType(iMimeType.getAsString());
        Document document = PeppolSBDHPayloadWriter.textContent().getAsDocument(textContentType);
        if (document == null) {
            throw new IllegalStateException("Failed to create 'TextContent' element.");
        }
        this.m_aBusinessMessage = document.getDocumentElement();
        return this;
    }

    public boolean hasBusinessMessage() {
        return this.m_aBusinessMessage != null;
    }

    @Nullable
    @ReturnsMutableCopy
    public Element getBusinessMessage() {
        return this.m_aBusinessMessage == null ? null : (Element)this.m_aBusinessMessage.cloneNode(true);
    }

    public boolean areAllFieldsSet() {
        return StringHelper.hasText((String)this.m_sSenderScheme) && StringHelper.hasText((String)this.m_sSenderValue) && StringHelper.hasText((String)this.m_sReceiverScheme) && StringHelper.hasText((String)this.m_sReceiverValue) && StringHelper.hasText((String)this.m_sDocumentTypeScheme) && StringHelper.hasText((String)this.m_sDocumentTypeValue) && StringHelper.hasText((String)this.m_sProcessScheme) && StringHelper.hasText((String)this.m_sProcessValue) && this.m_sStandard != null && this.m_sTypeVersion != null && this.m_sType != null && this.m_sInstanceIdentifier != null && this.m_aCreationDateAndTime != null && this.m_aBusinessMessage != null;
    }

    public boolean areAllAdditionalAttributesValid() {
        if (this.m_aAdditionalAttrs.isNotEmpty()) {
            for (String string : this.m_aAdditionalAttrs.keySet()) {
                if (!PeppolSBDHAdditionalAttributes.isReservedAttributeName(string)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PeppolSBDHDocument peppolSBDHDocument = (PeppolSBDHDocument)object;
        return EqualsHelper.equals((Object)this.m_sSenderScheme, (Object)peppolSBDHDocument.m_sSenderScheme) && EqualsHelper.equals((Object)this.m_sSenderValue, (Object)peppolSBDHDocument.m_sSenderValue) && EqualsHelper.equals((Object)this.m_sReceiverScheme, (Object)peppolSBDHDocument.m_sReceiverScheme) && EqualsHelper.equals((Object)this.m_sReceiverValue, (Object)peppolSBDHDocument.m_sReceiverValue) && EqualsHelper.equals((Object)this.m_sDocumentTypeScheme, (Object)peppolSBDHDocument.m_sDocumentTypeScheme) && EqualsHelper.equals((Object)this.m_sDocumentTypeValue, (Object)peppolSBDHDocument.m_sDocumentTypeValue) && EqualsHelper.equals((Object)this.m_sProcessScheme, (Object)peppolSBDHDocument.m_sProcessScheme) && EqualsHelper.equals((Object)this.m_sProcessValue, (Object)peppolSBDHDocument.m_sProcessValue) && EqualsHelper.equals((Object)this.m_sStandard, (Object)peppolSBDHDocument.m_sStandard) && EqualsHelper.equals((Object)this.m_sTypeVersion, (Object)peppolSBDHDocument.m_sTypeVersion) && EqualsHelper.equals((Object)this.m_sType, (Object)peppolSBDHDocument.m_sType) && EqualsHelper.equals((Object)this.m_sInstanceIdentifier, (Object)peppolSBDHDocument.m_sInstanceIdentifier) && EqualsHelper.equals((Object)this.m_aCreationDateAndTime, (Object)peppolSBDHDocument.m_aCreationDateAndTime) && EqualsHelper.equals((Object)this.m_aBusinessMessage, (Object)peppolSBDHDocument.m_aBusinessMessage) && this.m_aAdditionalAttrs.equals((Object)peppolSBDHDocument.m_aAdditionalAttrs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sSenderScheme).append((Object)this.m_sSenderValue).append((Object)this.m_sReceiverScheme).append((Object)this.m_sReceiverValue).append((Object)this.m_sDocumentTypeScheme).append((Object)this.m_sDocumentTypeValue).append((Object)this.m_sProcessScheme).append((Object)this.m_sProcessValue).append((Object)this.m_sStandard).append((Object)this.m_sTypeVersion).append((Object)this.m_sType).append((Object)this.m_sInstanceIdentifier).append((Object)this.m_aCreationDateAndTime).append((Node)this.m_aBusinessMessage).append((Map)this.m_aAdditionalAttrs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SenderScheme", (Object)this.m_sSenderScheme).append("SenderValue", (Object)this.m_sSenderValue).append("ReceiverScheme", (Object)this.m_sReceiverScheme).append("ReceiverValue", (Object)this.m_sReceiverValue).append("DocumentTypeScheme", (Object)this.m_sDocumentTypeScheme).append("DocumentTypeValue", (Object)this.m_sDocumentTypeValue).append("ProcessScheme", (Object)this.m_sProcessScheme).append("ProcessValue", (Object)this.m_sProcessValue).append("Standard", (Object)this.m_sStandard).append("TypeVersion", (Object)this.m_sTypeVersion).append("Type", (Object)this.m_sType).append("InstanceIdentifier", (Object)this.m_sInstanceIdentifier).append("CreationDateAndTime", (Object)this.m_aCreationDateAndTime).append("BusinessMessage", (Object)this.m_aBusinessMessage).append("AdditionalAttributes", (Object)this.m_aAdditionalAttrs).getToString();
    }

    @Nonnull
    public static PeppolSBDHDocument create(@Nonnull Element element, @Nonnull IIdentifierFactory iIdentifierFactory) {
        ValueEnforcer.notNull((Object)element, (String)"BusinessMessage");
        PeppolSBDHDocument peppolSBDHDocument = new PeppolSBDHDocument(iIdentifierFactory);
        peppolSBDHDocument.setBusinessMessage(element);
        peppolSBDHDocument.setDocumentIdentification(element.getNamespaceURI(), "2.1", element.getLocalName(), UUID.randomUUID().toString(), PDTFactory.getCurrentLocalDateTimeMillisOnly());
        return peppolSBDHDocument;
    }
}

