/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sbdh.read;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EPeppolSBDHDocumentReadError implements IHasID<String>
{
    INVALID_SBD_XML("invalid-sbd-xml", "Failed to interpret StandardBusinessDocument as XML"),
    MISSING_SBDH("missing-sbdh", "The StandardBusinessDocumentHeader element is not present"),
    INVALID_HEADER_VERSION("invalid-header-version", "The \"HeaderVersion\" element has an illegal value"),
    INVALID_SENDER_COUNT("invalid-sender-count", "Not exactly one \"Sender\" element is present"),
    INVALID_SENDER_AUTHORITY("invalid-sender-authority", "The \"Sender/Identifier/Authority\" attribute has an invalid value"),
    INVALID_SENDER_VALUE("invalid-sender-value", "The \"Sender/Identifier\" has an invalid value"),
    INVALID_RECEIVER_COUNT("invalid-receiver-count", "Not exactly one \"Receiver\" element is present"),
    INVALID_RECEIVER_AUTHORITY("invalid-receiver-authority", "The \"Receiver/Identifier/Authority\" attribute has an invalid value"),
    INVALID_RECEIVER_VALUE("invalid-receiver-value", "The \"Receiver/Identifier\" has an invalid value"),
    BUSINESS_SCOPE_MISSING("business-scope-missing", "The \"BusinessScope\" element is missing"),
    INVALID_SCOPE_COUNT("invalid-scope-count", "At least two \"BusinessScope/Scope\" elements must be present"),
    INVALID_DOCUMENT_TYPE_IDENTIFIER("invalid-document-type-identifier", "The provided document type identifier is invalid"),
    INVALID_PROCESS_IDENTIFIER("invalid-process-identifier", "The provided process identifier is invalid"),
    MISSING_DOCUMENT_TYPE_IDENTIFIER("missing-document-type-identifier", "The document type identifier is missing"),
    MISSING_PROCESS_IDENTIFIER("missing-process-identifier", "The process identifier is missing"),
    INVALID_BUSINESS_MESSAGE_TYPE("invalid-business-message-type", "The main business message must be an XML element"),
    INVALID_BUSINESS_MESSAGE("invalid-business-message", "The main business message is invalid"),
    INVALID_STANDARD("invalid-standard", "The value of the \"DocumentIdentification/Standard\" element is invalid"),
    INVALID_TYPE_VERSION("invalid-type-version", "The value of the \"DocumentIdentification/TypeVersion\" element is invalid"),
    INVALID_TYPE("invalid-type", "The value of the \"DocumentIdentification/Type\" element is invalid"),
    INVALID_INSTANCE_IDENTIFIER("invalid-instance-identifier", "The value of the \"DocumentIdentification/InstanceIdentifier\" element is invalid"),
    INVALID_CREATION_DATE_TIME("invalid-creation-date-time", "The value of the \"DocumentIdentification/CreationDateAndTime\" element is invalid");

    private final String m_sID;
    private final String m_sErrorMsg;

    private EPeppolSBDHDocumentReadError(String string2, String string3) {
        this.m_sID = string2;
        this.m_sErrorMsg = string3;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getErrorMessage() {
        return this.m_sErrorMsg;
    }

    @Nullable
    public static EPeppolSBDHDocumentReadError getFromIDOrNull(@Nullable String string) {
        return (EPeppolSBDHDocumentReadError)EnumHelper.getFromIDOrNull(EPeppolSBDHDocumentReadError.class, (Object)string);
    }
}

