/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.en16931;

import com.helger.bdve.EValidationType;
import com.helger.bdve.en16931.CEN16931;
import com.helger.bdve.executorset.IValidationExecutorSet;
import com.helger.bdve.executorset.TypedValidationResource;
import com.helger.bdve.executorset.VESID;
import com.helger.bdve.executorset.ValidationExecutorSet;
import com.helger.bdve.executorset.ValidationExecutorSetRegistry;
import com.helger.bdve.key.ValidationArtefactKey;
import com.helger.bdve.spi.LocationBeautifierSPI;
import com.helger.cii.d16b.CIID16BNamespaceContext;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.ubl21.UBL21NamespaceContext;
import com.helger.xml.XMLSystemProperties;
import com.helger.xml.namespace.IIterableNamespaceContext;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EN16931Validation {
    private static final String VERSION = "1.0.0";
    public static final VESID VID_UBL_1 = new VESID("eu.cen.en16931", "ubl", "1.0.0");
    public static final VESID VID_CII_1 = new VESID("eu.cen.en16931", "cii", "1.0.0");
    public static final VESID VID_EDIFACT_1 = new VESID("eu.cen.en16931", "edifact", "1.0.0");

    private EN16931Validation() {
    }

    @Nonnull
    private static TypedValidationResource _createPure(@Nonnull IReadableResource iReadableResource) {
        return new TypedValidationResource(EValidationType.SCHEMATRON_PURE, EN16931Validation.class.getClassLoader(), iReadableResource);
    }

    @Nonnull
    private static TypedValidationResource _createXSLT(@Nonnull IReadableResource iReadableResource) {
        return new TypedValidationResource(EValidationType.SCHEMATRON_XSLT, EN16931Validation.class.getClassLoader(), iReadableResource);
    }

    public static void initEN16931(@Nonnull ValidationExecutorSetRegistry validationExecutorSetRegistry) {
        ValueEnforcer.notNull((Object)validationExecutorSetRegistry, (String)"Registry");
        LocationBeautifierSPI.addMappings((IIterableNamespaceContext)UBL21NamespaceContext.getInstance());
        LocationBeautifierSPI.addMappings((IIterableNamespaceContext)CIID16BNamespaceContext.getInstance());
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_CII_1, (String)("EN 16931 CII " + VID_CII_1.getVersion()), (ValidationArtefactKey)CEN16931.VK_INVOICE_CII, (boolean)false, (TypedValidationResource[])new TypedValidationResource[]{EN16931Validation._createXSLT(CEN16931.INVOICE_CII_XSLT)}));
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_EDIFACT_1, (String)("EN 16931 EDIFACT/ISO 20625 " + VID_EDIFACT_1.getVersion()), (ValidationArtefactKey)CEN16931.VK_INVOICE_EDIFACT, (boolean)false, (TypedValidationResource[])new TypedValidationResource[]{EN16931Validation._createXSLT(CEN16931.INVOICE_EDIFACT_XSLT)}));
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_UBL_1, (String)("EN 16931 UBL " + VID_UBL_1.getVersion()), (ValidationArtefactKey)CEN16931.VK_INVOICE_UBL, (boolean)false, (TypedValidationResource[])new TypedValidationResource[]{EN16931Validation._createPure(CEN16931.INVOICE_UBL_SCH)}));
    }

    static {
        XMLSystemProperties.setXMLMaxOccurIfLarger((int)9999999);
    }
}

