/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.NonBlockingStack;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.dao.DAOException;
import com.helger.dao.IDAO;
import com.helger.dao.IDAOReadExceptionCallback;
import com.helger.dao.IDAOWriteExceptionCallback;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractDAO
implements IDAO {
    public static final boolean DEFAULT_AUTO_SAVE_ENABLED = true;
    public static final String FILENAME_EXTENSION_PREV = ".prev";
    public static final String FILENAME_EXTENSION_NEW = ".new";
    private static final CallbackList<IDAOReadExceptionCallback> s_aExceptionHandlersRead = new CallbackList();
    private static final CallbackList<IDAOWriteExceptionCallback> s_aExceptionHandlersWrite = new CallbackList();
    protected static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static final AtomicBoolean SILENT_MODE = new AtomicBoolean(true);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final NonBlockingStack<Boolean> m_aAutoSaveStack = new NonBlockingStack();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bPendingChanges = false;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bAutoSaveEnabled = true;

    public static boolean isSilentMode() {
        return SILENT_MODE.get();
    }

    public static boolean setSilentMode(boolean bl) {
        return SILENT_MODE.getAndSet(bl);
    }

    protected AbstractDAO() {
    }

    @Deprecated
    protected static final boolean isDebugLogging() {
        return !AbstractDAO.isSilentMode();
    }

    @Nonnull
    @ReturnsMutableObject
    public static final CallbackList<IDAOReadExceptionCallback> exceptionHandlersRead() {
        return s_aExceptionHandlersRead;
    }

    @Nonnull
    @ReturnsMutableObject
    public static final CallbackList<IDAOWriteExceptionCallback> exceptionHandlersWrite() {
        return s_aExceptionHandlersWrite;
    }

    @MustBeLocked(value=ELockType.READ)
    protected final boolean internalIsAutoSaveEnabled() {
        return this.m_bAutoSaveEnabled;
    }

    @Override
    public final boolean isAutoSaveEnabled() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bAutoSaveEnabled);
    }

    @MustBeLocked(value=ELockType.WRITE)
    public final void internalSetPendingChanges(boolean bl) {
        this.m_bPendingChanges = bl;
    }

    @MustBeLocked(value=ELockType.READ)
    public final boolean internalHasPendingChanges() {
        return this.m_bPendingChanges;
    }

    @Override
    public final boolean hasPendingChanges() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bPendingChanges);
    }

    @Override
    public final void beginWithoutAutoSave() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aAutoSaveStack.push((Object)this.m_bAutoSaveEnabled);
            this.m_bAutoSaveEnabled = false;
        });
    }

    @Override
    public final void endWithoutAutoSave() {
        boolean bl = this.m_aRWLock.writeLockedBoolean(() -> {
            boolean bl;
            this.m_bAutoSaveEnabled = bl = ((Boolean)this.m_aAutoSaveStack.pop()).booleanValue();
            return bl;
        });
        if (bl) {
            this.writeToFileOnPendingChanges();
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("autoSaveStack", this.m_aAutoSaveStack).append("pendingChanges", this.m_bPendingChanges).append("autoSaveEnabled", this.m_bAutoSaveEnabled).getToString();
    }

    protected static void checkFileAccess(@Nonnull File file, @Nonnull IDAO.EMode eMode) throws DAOException {
        ValueEnforcer.notNull((Object)file, (String)"File");
        ValueEnforcer.notNull((Object)((Object)eMode), (String)"Mode");
        String string = file.toString();
        if (file.exists()) {
            if (!file.isFile()) {
                throw new DAOException("The passed filename '" + string + "' is not a file - maybe a directory or a symlink? Path is '" + file.getAbsolutePath() + "'");
            }
            switch (eMode) {
                case READ: {
                    if (file.canRead()) break;
                    throw new DAOException("Read access rights from '" + file.getAbsolutePath() + "' are missing.");
                }
                case WRITE: {
                    if (file.canWrite()) break;
                    throw new DAOException("Write access rights to '" + file.getAbsolutePath() + "' are missing");
                }
            }
        } else {
            FileIOError fileIOError;
            File file2 = file.getParentFile();
            if (file2 != null && (fileIOError = FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file2)).isFailure()) {
                throw new DAOException("Failed to create parent directory '" + file2 + "' of '" + file.getAbsolutePath() + "': " + fileIOError);
            }
        }
    }
}

