/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime;

import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.id.IHasSimpleIntID;
import com.helger.commons.lang.DateFormatSymbolsFactory;
import com.helger.commons.lang.EnumHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EDayOfWeek implements IHasSimpleIntID
{
    MONDAY(1, 2),
    TUESDAY(2, 3),
    WEDNESDAY(3, 4),
    THURSDAY(4, 5),
    FRIDAY(5, 6),
    SATURDAY(6, 7),
    SUNDAY(7, 1);

    private final int m_nJodaID;
    private final int m_nCalID;

    private EDayOfWeek(int n2, int n3) {
        this.m_nJodaID = n2;
        this.m_nCalID = n3;
    }

    public int getID() {
        return this.m_nJodaID;
    }

    public int getDateTimeConstant() {
        return this.m_nJodaID;
    }

    public int getCalendarConstant() {
        return this.m_nCalID;
    }

    @Nullable
    public String getWeekdayName(@Nonnull Locale locale) {
        return (String)ArrayHelper.getSafeElement((Object[])DateFormatSymbolsFactory.getInstance((Locale)locale).getWeekdays(), (int)this.m_nCalID);
    }

    @Nullable
    public String getWeekdayShortName(@Nonnull Locale locale) {
        return (String)ArrayHelper.getSafeElement((Object[])DateFormatSymbolsFactory.getInstance((Locale)locale).getShortWeekdays(), (int)this.m_nCalID);
    }

    @Nullable
    public static EDayOfWeek getFromIDOrNull(int n) {
        return (EDayOfWeek)EnumHelper.getFromIDOrNull(EDayOfWeek.class, (int)n);
    }
}

