/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime;

import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.id.IHasSimpleIntID;
import com.helger.commons.lang.DateFormatSymbolsFactory;
import com.helger.commons.lang.EnumHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EMonth implements IHasSimpleIntID
{
    JANUARY(1, 0),
    FEBRUARY(2, 1),
    MARCH(3, 2),
    APRIL(4, 3),
    MAY(5, 4),
    JUNE(6, 5),
    JULY(7, 6),
    AUGUST(8, 7),
    SEPTEMBER(9, 8),
    OCTOBER(10, 9),
    NOVEMBER(11, 10),
    DECEMBER(12, 11);

    private final int m_nJodaID;
    private final int m_nCalID;

    private EMonth(int n2, int n3) {
        this.m_nJodaID = n2;
        this.m_nCalID = n3;
    }

    public int getID() {
        return this.m_nJodaID;
    }

    public int getDateTimeConstant() {
        return this.m_nJodaID;
    }

    public int getCalendarConstant() {
        return this.m_nCalID;
    }

    @Nullable
    public String getMonthName(@Nonnull Locale locale) {
        return (String)ArrayHelper.getSafeElement((Object[])DateFormatSymbolsFactory.getInstance((Locale)locale).getMonths(), (int)this.m_nCalID);
    }

    @Nullable
    public String getMonthShortName(@Nonnull Locale locale) {
        return (String)ArrayHelper.getSafeElement((Object[])DateFormatSymbolsFactory.getInstance((Locale)locale).getShortMonths(), (int)this.m_nCalID);
    }

    @Nullable
    public static EMonth getFromIDOrNull(int n) {
        return (EMonth)EnumHelper.getFromIDOrNull(EMonth.class, (int)n);
    }
}

