/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime;

import com.helger.datetime.CPDT;
import com.helger.datetime.config.PDTConfig;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MutableDateTime;

@Immutable
public final class PDTFactory {
    private static final PDTFactory s_aInstance = new PDTFactory();

    private PDTFactory() {
    }

    @Nonnull
    public static DateTime getCurrentDateTime() {
        return new DateTime(PDTConfig.getDefaultChronology());
    }

    @Nonnull
    public static DateTime getCurrentDateTimeUTC() {
        return new DateTime(PDTConfig.getDefaultChronologyUTC());
    }

    @Nonnull
    public static MutableDateTime getCurrentMutableDateTime() {
        return new MutableDateTime(PDTConfig.getDefaultChronology());
    }

    @Nonnull
    public static MutableDateTime getCurrentMutableDateTimeUTC() {
        return new MutableDateTime(PDTConfig.getDefaultChronologyUTC());
    }

    @Nonnull
    public static DateTime createDateTimeFromMillis(long l) {
        return new DateTime(l, PDTConfig.getDefaultChronology());
    }

    @Nonnull
    public static DateTime createDateTimeFromMillisUTC(long l) {
        return new DateTime(l, PDTConfig.getDefaultChronologyUTC());
    }

    @Nonnull
    public static DateTime createDateTime(int n, int n2, int n3) {
        return PDTFactory.createDateTime(n, n2, n3, 0, 0, 0, 0);
    }

    @Nonnull
    public static DateTime createDateTime(int n, int n2, int n3, int n4, int n5) {
        return PDTFactory.createDateTime(n, n2, n3, n4, n5, 0, 0);
    }

    @Nonnull
    public static DateTime createDateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        return PDTFactory.createDateTime(n, n2, n3, n4, n5, n6, 0);
    }

    @Nonnull
    public static DateTime createDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new DateTime(n, n2, n3, n4, n5, n6, n7, PDTConfig.getDefaultChronology());
    }

    @Nonnull
    public static DateTime createDateTime(@Nonnull String string) {
        return new DateTime((Object)string, PDTConfig.getDefaultChronology());
    }

    @Nonnull
    public static DateTime createDateTime(@Nonnull Date date) {
        return PDTFactory.createDateTime(date, PDTConfig.getDefaultDateTimeZone());
    }

    @Nonnull
    public static DateTime createDateTime(@Nonnull Date date, @Nonnull TimeZone timeZone) {
        return PDTFactory.createDateTime(date, DateTimeZone.forTimeZone((TimeZone)timeZone));
    }

    @Nonnull
    public static DateTime createDateTime(@Nonnull Date date, @Nonnull DateTimeZone dateTimeZone) {
        return new DateTime((Object)date, PDTConfig.getDefaultChronology().withZone(dateTimeZone));
    }

    @Nonnull
    public static DateTime createDateTime(@Nonnull Calendar calendar) {
        return new DateTime((Object)calendar, PDTConfig.getDefaultChronology().withZone(DateTimeZone.forTimeZone((TimeZone)calendar.getTimeZone())));
    }

    @Nonnull
    public static DateTime createDateTime(@Nonnull LocalDate localDate) {
        return localDate.toDateTimeAtStartOfDay(PDTFactory.getLocalDateTimeZone()).withChronology(PDTConfig.getDefaultChronology());
    }

    @Nonnull
    public static DateTime createDateTime(@Nonnull LocalTime localTime) {
        return CPDT.NULL_LOCAL_DATE.toDateTime(localTime, PDTFactory.getLocalDateTimeZone()).withChronology(PDTConfig.getDefaultChronology());
    }

    @Nonnull
    public static DateTime createDateTime(@Nonnull LocalDateTime localDateTime) {
        return localDateTime.toDateTime(PDTFactory.getLocalDateTimeZone()).withChronology(PDTConfig.getDefaultChronology());
    }

    @Nonnull
    public static Chronology getLocalChronology() {
        return PDTConfig.getDefaultChronology();
    }

    @Nonnull
    public static DateTimeZone getLocalDateTimeZone() {
        return PDTConfig.getDefaultDateTimeZone();
    }

    @Nonnull
    public static LocalDate getCurrentLocalDate() {
        return new LocalDate(PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalDate createLocalDateFromMillis(long l) {
        return new LocalDate(l, PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalDate createLocalDate(int n, int n2, int n3) {
        return new LocalDate(n, n2, n3, PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalDate createLocalDate(@Nonnull String string) {
        return new LocalDate((Object)string, PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalDate createLocalDate(@Nonnull Calendar calendar) {
        return new LocalDate((Object)calendar, PDTFactory.getLocalChronology().withZone(DateTimeZone.forTimeZone((TimeZone)calendar.getTimeZone())));
    }

    @Nonnull
    public static LocalDate createLocalDate(@Nonnull Date date) {
        return PDTFactory.createLocalDate(date, PDTConfig.getDefaultDateTimeZone());
    }

    @Nonnull
    public static LocalDate createLocalDate(@Nonnull Date date, TimeZone timeZone) {
        return PDTFactory.createLocalDate(date, DateTimeZone.forTimeZone((TimeZone)timeZone));
    }

    @Nonnull
    public static LocalDate createLocalDate(@Nonnull Date date, DateTimeZone dateTimeZone) {
        return new LocalDate((Object)date, PDTFactory.getLocalChronology().withZone(dateTimeZone));
    }

    @Nonnull
    public static LocalDate createLocalDate(@Nonnull DateTime dateTime) {
        return dateTime.toLocalDate();
    }

    @Nonnull
    public static LocalDate createLocalDate(@Nonnull LocalDateTime localDateTime) {
        return localDateTime.toLocalDate();
    }

    @Nonnull
    public static LocalTime getCurrentLocalTime() {
        return new LocalTime(PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalTime createLocalTimeFromMillis(long l) {
        return new LocalTime(l, PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalTime createLocalTime(int n, int n2) {
        return PDTFactory.createLocalTime(n, n2, 0, 0);
    }

    @Nonnull
    public static LocalTime createLocalTime(int n, int n2, int n3) {
        return PDTFactory.createLocalTime(n, n2, n3, 0);
    }

    @Nonnull
    public static LocalTime createLocalTime(int n, int n2, int n3, int n4) {
        return new LocalTime(n, n2, n3, n4, PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalTime createLocalTime(@Nonnull String string) {
        return new LocalTime((Object)string, PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalTime createLocalTime(@Nonnull Date date) {
        return PDTFactory.createLocalTime(date, PDTConfig.getDefaultDateTimeZone());
    }

    @Nonnull
    public static LocalTime createLocalTime(@Nonnull Date date, @Nonnull TimeZone timeZone) {
        return new LocalTime((Object)date, DateTimeZone.forTimeZone((TimeZone)timeZone));
    }

    @Nonnull
    public static LocalTime createLocalTime(@Nonnull Date date, @Nonnull DateTimeZone dateTimeZone) {
        return new LocalTime((Object)date, PDTFactory.getLocalChronology().withZone(dateTimeZone));
    }

    @Nonnull
    public static LocalTime createLocalTime(@Nonnull Calendar calendar) {
        return new LocalTime((Object)calendar, PDTFactory.getLocalChronology().withZone(DateTimeZone.forTimeZone((TimeZone)calendar.getTimeZone())));
    }

    @Nonnull
    public static LocalTime createLocalTime(@Nonnull DateTime dateTime) {
        return dateTime.toLocalTime();
    }

    @Nonnull
    public static LocalTime createLocalTime(@Nonnull LocalDateTime localDateTime) {
        return localDateTime.toLocalTime();
    }

    @Nonnull
    public static LocalDateTime getCurrentLocalDateTime() {
        return new LocalDateTime(PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull String string) {
        return new LocalDateTime((Object)string, PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull Date date) {
        return PDTFactory.createLocalDateTime(date, PDTConfig.getDefaultDateTimeZone());
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull Date date, @Nonnull TimeZone timeZone) {
        return PDTFactory.createLocalDateTime(date, DateTimeZone.forTimeZone((TimeZone)timeZone));
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull Date date, @Nonnull DateTimeZone dateTimeZone) {
        return new LocalDateTime((Object)date, PDTFactory.getLocalChronology().withZone(dateTimeZone));
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull Calendar calendar) {
        return new LocalDateTime((Object)calendar, PDTFactory.getLocalChronology().withZone(DateTimeZone.forTimeZone((TimeZone)calendar.getTimeZone())));
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull DateTime dateTime) {
        return dateTime.toLocalDateTime();
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull LocalDate localDate) {
        return PDTFactory.createLocalDateTime(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth());
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull LocalTime localTime) {
        return CPDT.NULL_LOCAL_DATE.toLocalDateTime(localTime);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTimeFromMillis(long l) {
        return new LocalDateTime(l, PDTFactory.getLocalChronology());
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(int n, int n2, int n3) {
        return PDTFactory.createLocalDateTime(n, n2, n3, 0, 0, 0, 0);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull LocalDate localDate, int n, int n2) {
        return PDTFactory.createLocalDateTime(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth(), n, n2, 0, 0);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull LocalDate localDate, int n, int n2, int n3) {
        return PDTFactory.createLocalDateTime(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth(), n, n2, n3, 0);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(@Nonnull LocalDate localDate, int n, int n2, int n3, int n4) {
        return PDTFactory.createLocalDateTime(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth(), n, n2, n3, n4);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(int n, int n2, int n3, int n4, int n5) {
        return PDTFactory.createLocalDateTime(n, n2, n3, n4, n5, 0, 0);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        return PDTFactory.createLocalDateTime(n, n2, n3, n4, n5, n6, 0);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new LocalDateTime(n, n2, n3, n4, n5, n6, n7, PDTFactory.getLocalChronology());
    }

    @Nonnegative
    public static long getCurrentMillis() {
        return DateTimeUtils.currentTimeMillis();
    }

    @Nonnegative
    public static int getCurrentYear() {
        return PDTFactory.getCurrentDateTime().getYear();
    }
}

