/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.pair.IReadonlyPair;
import com.helger.commons.collections.pair.ReadonlyPair;
import com.helger.datetime.CPDT;
import com.helger.datetime.PDTFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.base.AbstractInstant;
import org.joda.time.base.AbstractPartial;

@Immutable
public final class PDTUtils {
    private static final PDTUtils s_aInstance = new PDTUtils();

    private PDTUtils() {
    }

    public static boolean isNullValue(@Nullable LocalDate localDate) {
        return localDate == null || localDate == CPDT.NULL_LOCAL_DATE;
    }

    public static boolean isNullValue(@Nullable LocalTime localTime) {
        return localTime == null || localTime == CPDT.NULL_LOCAL_TIME;
    }

    public static boolean isNullValue(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null || localDateTime == CPDT.NULL_LOCAL_DATETIME;
    }

    public static boolean isNullValue(@Nullable DateTime dateTime) {
        return dateTime == null || dateTime == CPDT.NULL_DATETIME;
    }

    public static boolean isNullValue(@Nullable ReadableDateTime readableDateTime) {
        return readableDateTime == null || readableDateTime.getMillis() == 0L;
    }

    public static boolean isWeekendDay(int n) {
        return n == 6 || n == 7;
    }

    public static boolean isWeekend(@Nonnull ReadableDateTime readableDateTime) {
        return PDTUtils.isWeekendDay(readableDateTime.getDayOfWeek());
    }

    public static boolean isWeekend(@Nonnull LocalDate localDate) {
        return PDTUtils.isWeekendDay(localDate.getDayOfWeek());
    }

    public static boolean isFirstDayOfWeek(int n) {
        return n == 1;
    }

    public static boolean isFirstDayOfWeek(@Nonnull ReadableDateTime readableDateTime) {
        return PDTUtils.isFirstDayOfWeek(readableDateTime.getDayOfWeek());
    }

    public static boolean isFirstDayOfWeek(@Nonnull LocalDate localDate) {
        return PDTUtils.isFirstDayOfWeek(localDate.getDayOfWeek());
    }

    public static boolean isLastDayOfWeek(int n) {
        return n == 7;
    }

    public static boolean isLastDayOfWeek(@Nonnull ReadableDateTime readableDateTime) {
        return PDTUtils.isLastDayOfWeek(readableDateTime.getDayOfWeek());
    }

    public static boolean isLastDayOfWeek(@Nonnull LocalDate localDate) {
        return PDTUtils.isLastDayOfWeek(localDate.getDayOfWeek());
    }

    public static boolean isWorkDay(@Nonnull LocalDate localDate) {
        return !PDTUtils.isWeekend(localDate);
    }

    public static int getWeekDays(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        ValueEnforcer.notNull((Object)localDate, (String)"StartDate");
        ValueEnforcer.notNull((Object)localDate2, (String)"EndDate");
        boolean bl = localDate.isAfter((ReadablePartial)localDate2);
        LocalDate localDate3 = bl ? localDate2 : localDate;
        LocalDate localDate4 = bl ? localDate : localDate2;
        int n = 0;
        while (!localDate4.isBefore((ReadablePartial)localDate3)) {
            if (!PDTUtils.isWeekend(localDate3)) {
                ++n;
            }
            localDate3 = localDate3.plusDays(1);
        }
        return bl ? -1 * n : n;
    }

    public static boolean isSameYearAndDay(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.getYear() == localDate2.getYear() && localDate.getDayOfYear() == localDate2.getDayOfYear();
    }

    public static boolean isSameYearAndWeek(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.getYear() == localDate2.getYear() && localDate.getWeekOfWeekyear() == localDate2.getWeekOfWeekyear();
    }

    public static boolean isSameMonthAndDay(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.getMonthOfYear() == localDate2.getMonthOfYear() && localDate.getDayOfMonth() == localDate2.getDayOfMonth();
    }

    public static boolean isBetweenIncl(@Nullable LocalDate localDate, @Nullable LocalDate localDate2, @Nullable LocalDate localDate3) {
        if (localDate == null || localDate2 == null || localDate3 == null) {
            return false;
        }
        return !localDate2.isAfter((ReadablePartial)localDate) && !localDate.isAfter((ReadablePartial)localDate3);
    }

    @Nonnull
    public static IReadonlyPair<Integer, Integer> getWeeksOfMonth(@Nonnull DateTime dateTime) {
        int n = dateTime.withDayOfMonth(1).getWeekOfWeekyear();
        int n2 = dateTime.withDayOfMonth(dateTime.dayOfMonth().getMaximumValue()).getWeekOfWeekyear();
        return ReadonlyPair.create((Object)n, (Object)n2);
    }

    @Nonnull
    public static LocalDate getCurrentOrNextWeekday() {
        LocalDate localDate = PDTFactory.getCurrentLocalDate();
        while (PDTUtils.isWeekend(localDate)) {
            localDate = localDate.plusDays(1);
        }
        return localDate;
    }

    @Nonnull
    public static LocalDate getCurrentOrNextWorkDay() {
        LocalDate localDate = PDTFactory.getCurrentLocalDate();
        while (PDTUtils.isWorkDay(localDate)) {
            localDate = localDate.plusDays(1);
        }
        return localDate;
    }

    public static int birthdayCompare(@Nullable LocalDate localDate, @Nullable LocalDate localDate2) {
        if (localDate == localDate2) {
            return 0;
        }
        if (localDate == null) {
            return -1;
        }
        if (localDate2 == null) {
            return 1;
        }
        int n = localDate.getMonthOfYear() - localDate2.getMonthOfYear();
        if (n == 0) {
            n = localDate.getDayOfMonth() - localDate2.getDayOfMonth();
        }
        return n;
    }

    public static boolean birthdayEquals(@Nullable LocalDate localDate, @Nullable LocalDate localDate2) {
        return PDTUtils.birthdayCompare(localDate, localDate2) == 0;
    }

    public static boolean isNewYearsEve(@Nonnull LocalDate localDate) {
        if (localDate == null) {
            throw new NullPointerException("date");
        }
        return localDate.getMonthOfYear() == 12 && localDate.getDayOfMonth() == 31;
    }

    @Nullable
    public static <T extends AbstractPartial> T min(@Nullable T t, @Nullable T t2) {
        if (t == null) {
            return t2;
        }
        if (t2 == null) {
            return t;
        }
        return t.isBefore(t2) ? t : t2;
    }

    @Nullable
    public static <T extends AbstractPartial> T max(@Nullable T t, @Nullable T t2) {
        if (t == null) {
            return t2;
        }
        if (t2 == null) {
            return t;
        }
        return t.isAfter(t2) ? t : t2;
    }

    @Nullable
    public static <T extends AbstractInstant> T min(@Nullable T t, @Nullable T t2) {
        if (t == null) {
            return t2;
        }
        if (t2 == null) {
            return t;
        }
        return t.isBefore(t2) ? t : t2;
    }

    @Nullable
    public static <T extends AbstractInstant> T max(@Nullable T t, @Nullable T t2) {
        if (t == null) {
            return t2;
        }
        if (t2 == null) {
            return t;
        }
        return t.isAfter(t2) ? t : t2;
    }

    public static int compare(@Nonnull Period period, @Nonnull Period period2) {
        return period.toStandardDuration().compareTo((ReadableDuration)period2.toStandardDuration());
    }

    public static int nullSafeCompare(@Nullable Period period, @Nullable Period period2) {
        return period == period2 ? 0 : (period == null ? -1 : (period2 == null ? 1 : PDTUtils.compare(period, period2)));
    }

    public static boolean equals(@Nonnull Period period, @Nonnull Period period2) {
        return period == period2 || PDTUtils.compare(period, period2) == 0;
    }

    public static boolean isGreater(@Nonnull Period period, @Nonnull Period period2) {
        return PDTUtils.compare(period, period2) > 0;
    }

    public static boolean isGreaterOrEqual(@Nonnull Period period, @Nonnull Period period2) {
        return PDTUtils.compare(period, period2) >= 0;
    }

    public static boolean isLess(@Nonnull Period period, @Nonnull Period period2) {
        return PDTUtils.compare(period, period2) < 0;
    }

    public static boolean isLessOrEqual(@Nonnull Period period, @Nonnull Period period2) {
        return PDTUtils.compare(period, period2) <= 0;
    }

    public static int nullSafeCompare(@Nullable Duration duration, @Nullable Duration duration2) {
        return duration == duration2 ? 0 : (duration == null ? -1 : (duration2 == null ? 1 : duration.compareTo((ReadableDuration)duration2)));
    }

    public static boolean isGreater(@Nonnull Duration duration, @Nonnull Duration duration2) {
        return duration.compareTo((ReadableDuration)duration2) > 0;
    }

    public static boolean isGreaterOrEqual(@Nonnull Duration duration, @Nonnull Duration duration2) {
        return duration.compareTo((ReadableDuration)duration2) >= 0;
    }

    public static boolean isLess(@Nonnull Duration duration, @Nonnull Duration duration2) {
        return duration.compareTo((ReadableDuration)duration2) < 0;
    }

    public static boolean isLessOrEqual(@Nonnull Duration duration, @Nonnull Duration duration2) {
        return duration.compareTo((ReadableDuration)duration2) <= 0;
    }

    public static int nullSafeCompare(@Nullable DateTime dateTime, @Nullable DateTime dateTime2) {
        return dateTime == dateTime2 ? 0 : (dateTime == null ? -1 : (dateTime2 == null ? 1 : dateTime.compareTo((ReadableInstant)dateTime2)));
    }

    public static boolean isGreater(@Nonnull DateTime dateTime, @Nonnull DateTime dateTime2) {
        return dateTime.compareTo((ReadableInstant)dateTime2) > 0;
    }

    public static boolean isGreaterOrEqual(@Nonnull DateTime dateTime, @Nonnull DateTime dateTime2) {
        return dateTime.compareTo((ReadableInstant)dateTime2) >= 0;
    }

    public static boolean isLess(@Nonnull DateTime dateTime, @Nonnull DateTime dateTime2) {
        return dateTime.compareTo((ReadableInstant)dateTime2) < 0;
    }

    public static boolean isLessOrEqual(@Nonnull DateTime dateTime, @Nonnull DateTime dateTime2) {
        return dateTime.compareTo((ReadableInstant)dateTime2) <= 0;
    }

    public static int nullSafeCompare(@Nullable LocalDate localDate, @Nullable LocalDate localDate2) {
        return localDate == localDate2 ? 0 : (localDate == null ? -1 : (localDate2 == null ? 1 : localDate.compareTo((ReadablePartial)localDate2)));
    }

    public static boolean isGreater(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.compareTo((ReadablePartial)localDate2) > 0;
    }

    public static boolean isGreaterOrEqual(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.compareTo((ReadablePartial)localDate2) >= 0;
    }

    public static boolean isLess(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.compareTo((ReadablePartial)localDate2) < 0;
    }

    public static boolean isLessOrEqual(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.compareTo((ReadablePartial)localDate2) <= 0;
    }

    public static int nullSafeCompare(@Nullable LocalTime localTime, @Nullable LocalTime localTime2) {
        return localTime == localTime2 ? 0 : (localTime == null ? -1 : (localTime2 == null ? 1 : localTime.compareTo((ReadablePartial)localTime2)));
    }

    public static boolean isGreater(@Nonnull LocalTime localTime, @Nonnull LocalTime localTime2) {
        return localTime.compareTo((ReadablePartial)localTime2) > 0;
    }

    public static boolean isGreaterOrEqual(@Nonnull LocalTime localTime, @Nonnull LocalTime localTime2) {
        return localTime.compareTo((ReadablePartial)localTime2) >= 0;
    }

    public static boolean isLess(@Nonnull LocalTime localTime, @Nonnull LocalTime localTime2) {
        return localTime.compareTo((ReadablePartial)localTime2) < 0;
    }

    public static boolean isLessOrEqual(@Nonnull LocalTime localTime, @Nonnull LocalTime localTime2) {
        return localTime.compareTo((ReadablePartial)localTime2) <= 0;
    }

    public static int nullSafeCompare(@Nullable LocalDateTime localDateTime, @Nullable LocalDateTime localDateTime2) {
        return localDateTime == localDateTime2 ? 0 : (localDateTime == null ? -1 : (localDateTime2 == null ? 1 : localDateTime.compareTo((ReadablePartial)localDateTime2)));
    }

    public static boolean isGreater(@Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2) {
        return localDateTime.compareTo((ReadablePartial)localDateTime2) > 0;
    }

    public static boolean isGreaterOrEqual(@Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2) {
        return localDateTime.compareTo((ReadablePartial)localDateTime2) >= 0;
    }

    public static boolean isLess(@Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2) {
        return localDateTime.compareTo((ReadablePartial)localDateTime2) < 0;
    }

    public static boolean isLessOrEqual(@Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2) {
        return localDateTime.compareTo((ReadablePartial)localDateTime2) <= 0;
    }
}

