/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.config;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.state.ESuccess;
import java.util.TimeZone;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PDTConfig {
    public static final String DEFAULT_DATETIMEZONEID = "Europe/Vienna";
    public static final boolean DEFAULT_USE_ISO_CHRONOLOGY = true;
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDTConfig.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static DateTimeZone s_aDefaultDateTimeZone;
    @GuardedBy(value="s_aRWLock")
    private static volatile boolean s_bUseISOChronology;
    private static final PDTConfig s_aInstance;

    private PDTConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess setDefaultDateTimeZoneID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DateTimeZoneID");
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultDateTimeZone = DateTimeZone.forID((String)string);
            TimeZone timeZone = TimeZone.getTimeZone(string);
            TimeZone.setDefault(timeZone);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            s_aLogger.warn("Unsupported dateTimeZone ID '" + string + "'");
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static DateTimeZone getDefaultDateTimeZone() {
        s_aRWLock.readLock().lock();
        try {
            DateTimeZone dateTimeZone = s_aDefaultDateTimeZone;
            return dateTimeZone;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    public static DateTimeZone getDateTimeZoneUTC() {
        return DateTimeZone.UTC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUseISOChronology() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_bUseISOChronology;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUseISOChronology(boolean bl) {
        s_aRWLock.writeLock().lock();
        try {
            s_bUseISOChronology = bl;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    public static Chronology getDefaultChronology() {
        if (PDTConfig.isUseISOChronology()) {
            return ISOChronology.getInstance((DateTimeZone)PDTConfig.getDefaultDateTimeZone());
        }
        return GJChronology.getInstance((DateTimeZone)PDTConfig.getDefaultDateTimeZone());
    }

    @Nonnull
    public static Chronology getDefaultChronologyUTC() {
        if (PDTConfig.isUseISOChronology()) {
            return ISOChronology.getInstanceUTC();
        }
        return GJChronology.getInstanceUTC();
    }

    @Nonnull
    public static Chronology getDefaultChronologyWithDefaultDateTimeZone() {
        if (PDTConfig.isUseISOChronology()) {
            return ISOChronology.getInstance();
        }
        return GJChronology.getInstance();
    }

    static {
        s_bUseISOChronology = true;
        PDTConfig.setDefaultDateTimeZoneID(DEFAULT_DATETIMEZONEID);
        s_aInstance = new PDTConfig();
    }
}

