/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.config;

import com.helger.commons.annotations.IsSPIImplementation;
import com.helger.commons.typeconvert.ITypeConverter;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import com.helger.datetime.PDTFactory;
import com.helger.datetime.config.PDTConfig;
import com.helger.datetime.config.PDTJodaNumberConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.DurationConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.PartialConverter;

@Immutable
@IsSPIImplementation
public final class PDTTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    private static void _registerJodaConverter() {
        ConverterManager.getInstance().addInstantConverter((InstantConverter)PDTJodaNumberConverter.INSTANCE);
        ConverterManager.getInstance().addPartialConverter((PartialConverter)PDTJodaNumberConverter.INSTANCE);
        ConverterManager.getInstance().addDurationConverter((DurationConverter)PDTJodaNumberConverter.INSTANCE);
    }

    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        PDTTypeConverterRegistrar._registerJodaConverter();
        Class[] classArray = new Class[]{String.class, Calendar.class, GregorianCalendar.class, Date.class, AtomicInteger.class, AtomicLong.class, BigDecimal.class, BigInteger.class, Byte.class, Double.class, Float.class, Integer.class, Long.class, Short.class};
        iTypeConverterRegistry.registerTypeConverter(classArray, DateTime.class, new ITypeConverter(){

            @Nonnull
            public DateTime convert(@Nonnull Object object) {
                return new DateTime(object, PDTConfig.getDefaultChronology());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, DateTime.class, new ITypeConverter(){

            @Nonnull
            public DateTime convert(@Nonnull Object object) {
                return PDTFactory.createDateTime((LocalDate)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, DateTime.class, new ITypeConverter(){

            @Nonnull
            public DateTime convert(@Nonnull Object object) {
                return PDTFactory.createDateTime((LocalTime)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, DateTime.class, new ITypeConverter(){

            @Nonnull
            public DateTime convert(@Nonnull Object object) {
                return PDTFactory.createDateTime((LocalDateTime)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(classArray, LocalDateTime.class, new ITypeConverter(){

            @Nonnull
            public LocalDateTime convert(@Nonnull Object object) {
                return new LocalDateTime(object, PDTConfig.getDefaultChronology());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(DateTime.class, LocalDateTime.class, new ITypeConverter(){

            @Nonnull
            public LocalDateTime convert(@Nonnull Object object) {
                return PDTFactory.createLocalDateTime((DateTime)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, LocalDateTime.class, new ITypeConverter(){

            @Nonnull
            public LocalDateTime convert(@Nonnull Object object) {
                return PDTFactory.createLocalDateTime((LocalDate)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, LocalDateTime.class, new ITypeConverter(){

            @Nonnull
            public LocalDateTime convert(@Nonnull Object object) {
                return PDTFactory.createLocalDateTime((LocalTime)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(classArray, LocalDate.class, new ITypeConverter(){

            @Nonnull
            public LocalDate convert(@Nonnull Object object) {
                return new LocalDate(object, PDTConfig.getDefaultChronology());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(DateTime.class, LocalDate.class, new ITypeConverter(){

            @Nonnull
            public LocalDate convert(@Nonnull Object object) {
                return PDTFactory.createLocalDate((DateTime)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, LocalDate.class, new ITypeConverter(){

            @Nonnull
            public LocalDate convert(@Nonnull Object object) {
                return PDTFactory.createLocalDate((LocalDateTime)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(classArray, LocalTime.class, new ITypeConverter(){

            @Nonnull
            public LocalTime convert(@Nonnull Object object) {
                return new LocalTime(object, PDTConfig.getDefaultChronology());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(DateTime.class, LocalTime.class, new ITypeConverter(){

            @Nonnull
            public LocalTime convert(@Nonnull Object object) {
                return PDTFactory.createLocalTime((DateTime)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, LocalTime.class, new ITypeConverter(){

            @Nonnull
            public LocalTime convert(@Nonnull Object object) {
                return PDTFactory.createLocalTime((LocalDateTime)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(new Class[]{String.class, AtomicInteger.class, AtomicLong.class, BigDecimal.class, BigInteger.class, Byte.class, Double.class, Float.class, Integer.class, Long.class, Short.class}, Duration.class, new ITypeConverter(){

            @Nonnull
            public Duration convert(@Nonnull Object object) {
                return new Duration(object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(new Class[]{String.class, AtomicInteger.class, AtomicLong.class, BigDecimal.class, BigInteger.class, Byte.class, Double.class, Float.class, Integer.class, Long.class, Short.class}, Period.class, new ITypeConverter(){

            @Nonnull
            public Period convert(@Nonnull Object object) {
                return new Period(object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(new Class[]{String.class, AtomicInteger.class, AtomicLong.class, BigDecimal.class, BigInteger.class, Byte.class, Double.class, Float.class, Integer.class, Long.class, Short.class}, MutablePeriod.class, new ITypeConverter(){

            @Nonnull
            public MutablePeriod convert(@Nonnull Object object) {
                return new MutablePeriod(object);
            }
        });
    }
}

