/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.expiration;

import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.expiration.IExpirable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public final class Expirable
implements IExpirable {
    private DateTime m_aExpirationDateTime;

    public Expirable() {
    }

    public Expirable(@Nullable DateTime dateTime) {
        this.m_aExpirationDateTime = dateTime;
    }

    @Override
    public boolean isExpirationDefined() {
        return this.m_aExpirationDateTime != null;
    }

    @Override
    public boolean isExpired() {
        return this.isExpirationDefined() && this.getExpirationDateTime().isBeforeNow();
    }

    @Override
    @Nullable
    public DateTime getExpirationDateTime() {
        return this.m_aExpirationDateTime;
    }

    @Override
    @Nonnull
    public EChange setExpirationDateTime(@Nullable DateTime dateTime) {
        if (EqualsUtils.equals((Object)dateTime, (Object)this.m_aExpirationDateTime)) {
            return EChange.UNCHANGED;
        }
        this.m_aExpirationDateTime = dateTime;
        return EChange.CHANGED;
    }

    @Override
    public EChange resetExpiration() {
        return this.setExpirationDateTime(null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Expirable)) {
            return false;
        }
        Expirable expirable = (Expirable)object;
        return EqualsUtils.equals((Object)this.m_aExpirationDateTime, (Object)expirable.m_aExpirationDateTime);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aExpirationDateTime).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("expirationDT", (Object)this.m_aExpirationDateTime).toString();
    }
}

