/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.expiration;

import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.expiration.IExpirableWithReplacement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public final class ExpirableWithReplacement<DATATYPE>
implements IExpirableWithReplacement<DATATYPE> {
    private DateTime m_aExpirationDateTime;
    private DATATYPE m_aReplacement;

    public ExpirableWithReplacement() {
    }

    public ExpirableWithReplacement(@Nullable DateTime dateTime, @Nullable DATATYPE DATATYPE) {
        this.m_aExpirationDateTime = dateTime;
        this.m_aReplacement = DATATYPE;
    }

    @Override
    public boolean isExpirationDefined() {
        return this.m_aExpirationDateTime != null;
    }

    @Override
    public boolean isExpired() {
        return this.isExpirationDefined() && this.getExpirationDateTime().isBeforeNow();
    }

    @Override
    @Nullable
    public DateTime getExpirationDateTime() {
        return this.m_aExpirationDateTime;
    }

    @Override
    @Nonnull
    public EChange setExpirationDateTime(@Nullable DateTime dateTime) {
        if (EqualsUtils.equals((Object)dateTime, (Object)this.m_aExpirationDateTime)) {
            return EChange.UNCHANGED;
        }
        this.m_aExpirationDateTime = dateTime;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public DATATYPE getReplacement() {
        return this.m_aReplacement;
    }

    @Override
    @Nonnull
    public EChange setReplacement(@Nullable DATATYPE DATATYPE) {
        if (EqualsUtils.equals(DATATYPE, this.m_aReplacement)) {
            return EChange.UNCHANGED;
        }
        this.m_aReplacement = DATATYPE;
        return EChange.CHANGED;
    }

    @Override
    public EChange resetExpiration() {
        return this.setExpirationDateTime(null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExpirableWithReplacement)) {
            return false;
        }
        ExpirableWithReplacement expirableWithReplacement = (ExpirableWithReplacement)object;
        return EqualsUtils.equals((Object)this.m_aExpirationDateTime, (Object)expirableWithReplacement.m_aExpirationDateTime) && EqualsUtils.equals(this.m_aReplacement, expirableWithReplacement.m_aReplacement);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aExpirationDateTime).append(this.m_aReplacement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("expirationDT", (Object)this.m_aExpirationDateTime).append("replacement", this.m_aReplacement).toString();
    }
}

