/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.expiration;

import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.expiration.IReadonlyExpirable;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public final class ReadonlyExpirable
implements IReadonlyExpirable {
    private final DateTime m_aExpirationDateTime;

    public ReadonlyExpirable(@Nullable DateTime dateTime) {
        this.m_aExpirationDateTime = dateTime;
    }

    @Override
    public boolean isExpirationDefined() {
        return this.m_aExpirationDateTime != null;
    }

    @Override
    public boolean isExpired() {
        return this.isExpirationDefined() && this.getExpirationDateTime().isBeforeNow();
    }

    @Override
    @Nullable
    public DateTime getExpirationDateTime() {
        return this.m_aExpirationDateTime;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ReadonlyExpirable)) {
            return false;
        }
        ReadonlyExpirable readonlyExpirable = (ReadonlyExpirable)object;
        return EqualsUtils.equals((Object)this.m_aExpirationDateTime, (Object)readonlyExpirable.m_aExpirationDateTime);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aExpirationDateTime).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("expirationDT", (Object)this.m_aExpirationDateTime).toString();
    }
}

