/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.expiration;

import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.expiration.IReadonlyExpirableWithReplacement;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public final class ReadonlyExpirableWithReplacement<DATATYPE>
implements IReadonlyExpirableWithReplacement<DATATYPE> {
    private final DateTime m_aExpirationDateTime;
    private final DATATYPE m_aReplacement;

    public ReadonlyExpirableWithReplacement(@Nullable DateTime dateTime, @Nullable DATATYPE DATATYPE) {
        this.m_aExpirationDateTime = dateTime;
        this.m_aReplacement = DATATYPE;
    }

    @Override
    public boolean isExpirationDefined() {
        return this.m_aExpirationDateTime != null;
    }

    @Override
    public boolean isExpired() {
        return this.isExpirationDefined() && this.getExpirationDateTime().isBeforeNow();
    }

    @Override
    @Nullable
    public DateTime getExpirationDateTime() {
        return this.m_aExpirationDateTime;
    }

    @Override
    @Nullable
    public DATATYPE getReplacement() {
        return this.m_aReplacement;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ReadonlyExpirableWithReplacement)) {
            return false;
        }
        ReadonlyExpirableWithReplacement readonlyExpirableWithReplacement = (ReadonlyExpirableWithReplacement)object;
        return EqualsUtils.equals((Object)this.m_aExpirationDateTime, (Object)readonlyExpirableWithReplacement.m_aExpirationDateTime) && EqualsUtils.equals(this.m_aReplacement, readonlyExpirableWithReplacement.m_aReplacement);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aExpirationDateTime).append(this.m_aReplacement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("expirationDT", (Object)this.m_aExpirationDateTime).append("replacement", this.m_aReplacement).toString();
    }
}

