/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PDTFormatPatterns {
    private static final PDTFormatPatterns s_aInstance = new PDTFormatPatterns();

    private PDTFormatPatterns() {
    }

    @Nonnull
    private static String _getPatternDate(int n, @Nonnull Locale locale) {
        return ((SimpleDateFormat)DateFormat.getDateInstance(n, locale)).toPattern();
    }

    @Nonnull
    public static String getDefaultPatternDate(@Nonnull Locale locale) {
        return PDTFormatPatterns.getMediumPatternDate(locale);
    }

    @Nonnull
    public static String getShortPatternDate(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternDate(3, locale);
    }

    @Nonnull
    public static String getMediumPatternDate(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternDate(2, locale);
    }

    @Nonnull
    public static String getLongPatternDate(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternDate(1, locale);
    }

    @Nonnull
    public static String getFullPatternDate(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternDate(0, locale);
    }

    @Nonnull
    private static String _getPatternTime(int n, @Nonnull Locale locale) {
        return ((SimpleDateFormat)DateFormat.getTimeInstance(n, locale)).toPattern();
    }

    @Nonnull
    public static String getDefaultPatternTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getMediumPatternTime(locale);
    }

    @Nonnull
    public static String getShortPatternTime(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternTime(3, locale);
    }

    @Nonnull
    public static String getMediumPatternTime(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternTime(2, locale);
    }

    @Nonnull
    public static String getLongPatternTime(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternTime(1, locale);
    }

    @Nonnull
    public static String getFullPatternTime(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternTime(0, locale);
    }

    @Nonnull
    private static String _getPatternDateTime(int n, @Nonnull Locale locale) {
        return ((SimpleDateFormat)DateFormat.getDateTimeInstance(n, n, locale)).toPattern();
    }

    @Nonnull
    public static String getDefaultPatternDateTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getMediumPatternDateTime(locale);
    }

    @Nonnull
    public static String getShortPatternDateTime(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternDateTime(3, locale);
    }

    @Nonnull
    public static String getMediumPatternDateTime(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternDateTime(2, locale);
    }

    @Nonnull
    public static String getLongPatternDateTime(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternDateTime(1, locale);
    }

    @Nonnull
    public static String getFullPatternDateTime(@Nonnull Locale locale) {
        return PDTFormatPatterns._getPatternDateTime(0, locale);
    }
}

