/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.datetime.config.PDTConfig;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Immutable
public final class PDTFormatter {
    private static final PDTFormatter s_aInstance = new PDTFormatter();

    private PDTFormatter() {
    }

    @Nonnull
    public static DateTimeFormatter getWithLocaleAndChrono(@Nonnull DateTimeFormatter dateTimeFormatter, @Nullable Locale locale) {
        return dateTimeFormatter.withLocale(locale).withChronology(PDTConfig.getDefaultChronology());
    }

    @Nonnull
    public static DateTimeFormatter getDefaultFormatterDate(@Nullable Locale locale) {
        return PDTFormatter.getMediumFormatterDate(locale);
    }

    @Nonnull
    public static DateTimeFormatter getShortFormatterDate(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.shortDate(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getMediumFormatterDate(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.mediumDate(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getLongFormatterDate(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.longDate(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFullFormatterDate(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.fullDate(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getDefaultFormatterTime(@Nullable Locale locale) {
        return PDTFormatter.getMediumFormatterTime(locale);
    }

    @Nonnull
    public static DateTimeFormatter getShortFormatterTime(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.shortTime(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getMediumFormatterTime(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.mediumTime(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getLongFormatterTime(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.longTime(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFullFormatterTime(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.fullTime(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getDefaultFormatterDateTime(@Nullable Locale locale) {
        return PDTFormatter.getMediumFormatterDateTime(locale);
    }

    @Nonnull
    public static DateTimeFormatter getShortFormatterDateTime(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.shortDateTime(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getMediumFormatterDateTime(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.mediumDateTime(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getLongFormatterDateTime(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.longDateTime(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFullFormatterDateTime(@Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.fullDateTime(), locale);
    }

    @Nonnull
    public static DateTimeFormatter getForPattern(@Nonnull String string) throws IllegalArgumentException {
        return PDTFormatter.getForPattern(string, null);
    }

    @Nonnull
    public static DateTimeFormatter getForPattern(@Nonnull String string, @Nullable Locale locale) throws IllegalArgumentException {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.forPattern((String)string), locale);
    }
}

