/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.commons.string.StringHelper;
import com.helger.datetime.format.PDTFormatter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PDTFromString {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDTFromString.class);
    private static final PDTFromString s_aInstance = new PDTFromString();

    private PDTFromString() {
    }

    @Nullable
    public static DateTime getDateTimeFromString(@Nullable String string, @Nonnull String string2) {
        return PDTFromString.getDateTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    @Nullable
    public static DateTime getDateTimeFromString(@Nullable String string, @Nonnull DateTimeFormatter dateTimeFormatter) {
        block4: {
            if (dateTimeFormatter == null) {
                throw new NullPointerException("dateTimeFormatter");
            }
            if (StringHelper.hasText((String)string)) {
                try {
                    return dateTimeFormatter.parseDateTime(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!s_aLogger.isDebugEnabled()) break block4;
                    s_aLogger.debug("Failed to parse date '" + string + "' with " + dateTimeFormatter);
                }
            }
        }
        return null;
    }

    @Nullable
    public static DateTime getDefaultDateFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getDateTimeFromString(string, PDTFormatter.getDefaultFormatterDate(locale));
    }

    @Nullable
    public static DateTime getDefaultTimeFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getDateTimeFromString(string, PDTFormatter.getDefaultFormatterTime(locale));
    }

    @Nullable
    public static DateTime getDefaultDateTimeFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getDateTimeFromString(string, PDTFormatter.getDefaultFormatterDateTime(locale));
    }

    @Nullable
    public static LocalDate getLocalDateFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getLocalDateFromString(string, PDTFormatter.getDefaultFormatterDate(locale));
    }

    @Nullable
    public static LocalDate getLocalDateFromString(@Nullable String string, @Nonnull DateTimeFormatter dateTimeFormatter) {
        DateTime dateTime = PDTFromString.getDateTimeFromString(string, dateTimeFormatter);
        return dateTime == null ? null : dateTime.toLocalDate();
    }

    @Nullable
    public static LocalDate getLocalDateFromString(@Nullable String string, @Nonnull String string2) {
        DateTime dateTime = PDTFromString.getDateTimeFromString(string, string2);
        return dateTime == null ? null : dateTime.toLocalDate();
    }

    @Nullable
    public static LocalDateTime getLocalDateTimeFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getLocalDateTimeFromString(string, PDTFormatter.getDefaultFormatterDateTime(locale));
    }

    @Nullable
    public static LocalDateTime getLocalDateTimeFromString(@Nullable String string, @Nonnull DateTimeFormatter dateTimeFormatter) {
        DateTime dateTime = PDTFromString.getDateTimeFromString(string, dateTimeFormatter);
        return dateTime == null ? null : dateTime.toLocalDateTime();
    }

    @Nullable
    public static LocalDateTime getLocalDateTimeFromString(@Nullable String string, @Nonnull String string2) {
        DateTime dateTime = PDTFromString.getDateTimeFromString(string, string2);
        return dateTime == null ? null : dateTime.toLocalDateTime();
    }

    @Nullable
    public static LocalTime getLocalTimeFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getLocalTimeFromString(string, PDTFormatter.getDefaultFormatterTime(locale));
    }

    @Nullable
    public static LocalTime getLocalTimeFromString(@Nullable String string, @Nonnull DateTimeFormatter dateTimeFormatter) {
        DateTime dateTime = PDTFromString.getDateTimeFromString(string, dateTimeFormatter);
        return dateTime == null ? null : dateTime.toLocalTime();
    }

    @Nullable
    public static LocalTime getLocalTimeFromString(@Nullable String string, @Nonnull String string2) {
        DateTime dateTime = PDTFromString.getDateTimeFromString(string, string2);
        return dateTime == null ? null : dateTime.toLocalTime();
    }
}

