/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.datetime.format.PDTFormatter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

@Immutable
public final class PDTToString {
    private static final PDTToString s_aInstance = new PDTToString();

    private PDTToString() {
    }

    @Nullable
    public static String getAsString(@Nullable LocalDate localDate, @Nonnull Locale locale) {
        return localDate == null ? null : PDTFormatter.getDefaultFormatterDate(locale).print((ReadablePartial)localDate);
    }

    @Nullable
    public static String getAsString(@Nullable LocalTime localTime, @Nonnull Locale locale) {
        return localTime == null ? null : PDTFormatter.getDefaultFormatterTime(locale).print((ReadablePartial)localTime);
    }

    @Nullable
    public static String getAsString(@Nullable LocalDateTime localDateTime, @Nonnull Locale locale) {
        return localDateTime == null ? null : PDTFormatter.getDefaultFormatterDateTime(locale).print((ReadablePartial)localDateTime);
    }

    @Nullable
    public static String getAsString(@Nullable DateTime dateTime, @Nonnull Locale locale) {
        return dateTime == null ? null : PDTFormatter.getDefaultFormatterDateTime(locale).print((ReadableInstant)dateTime);
    }

    @Nullable
    public static String getAsString(@Nonnull String string, @Nullable ReadablePartial readablePartial) {
        return PDTToString.getAsString(string, readablePartial, (Locale)null);
    }

    @Nullable
    public static String getAsString(@Nonnull String string, @Nullable ReadablePartial readablePartial, @Nullable Locale locale) {
        return readablePartial == null ? null : PDTFormatter.getForPattern(string, locale).print(readablePartial);
    }

    @Nullable
    public static String getAsString(@Nonnull String string, @Nullable ReadableInstant readableInstant) {
        return PDTToString.getAsString(string, readableInstant, (Locale)null);
    }

    @Nullable
    public static String getAsString(@Nonnull String string, @Nullable ReadableInstant readableInstant, @Nullable Locale locale) {
        return readableInstant == null ? null : PDTFormatter.getForPattern(string, locale).print(readableInstant);
    }
}

