/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.commons.annotations.Translatable;
import com.helger.commons.name.IHasDisplayText;
import com.helger.commons.text.ITextProvider;
import com.helger.commons.text.impl.TextProvider;
import com.helger.commons.text.resolve.DefaultTextResolver;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

@NotThreadSafe
public final class PeriodFormatMultilingual {
    private static final PeriodFormatMultilingual s_aInstance = new PeriodFormatMultilingual();

    private PeriodFormatMultilingual() {
    }

    @Nonnull
    private static String[] _getSeparatorVariants(Locale locale) {
        String string = EText.LONG_SEPARATOR_FRONT.getDisplayText(locale);
        String string2 = EText.LONG_SEPARATOR_LAST.getDisplayText(locale);
        return new String[]{" ", string.trim(), string.trim() + string2.trim() + " ", string.trim() + string2};
    }

    @Nonnull
    public static PeriodFormatter getFormatterLong(@Nonnull Locale locale) {
        String string = EText.LONG_SEPARATOR_FRONT.getDisplayText(locale);
        String string2 = EText.LONG_SEPARATOR_LAST.getDisplayText(locale);
        String[] stringArray = PeriodFormatMultilingual._getSeparatorVariants(locale);
        return new PeriodFormatterBuilder().appendYears().appendSuffix(EText.LONG_YEAR_SINGULAR.getDisplayText(locale), EText.LONG_YEAR_PLURAL.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendMonths().appendSuffix(EText.LONG_MONTH_SINGULAR.getDisplayText(locale), EText.LONG_MONTH_PLURAL.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendWeeks().appendSuffix(EText.LONG_WEEK_SINGULAR.getDisplayText(locale), EText.LONG_WEEK_PLURAL.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendDays().appendSuffix(EText.LONG_DAY_SINGULAR.getDisplayText(locale), EText.LONG_DAY_PLURAL.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendHours().appendSuffix(EText.LONG_HOUR_SINGULAR.getDisplayText(locale), EText.LONG_HOUR_PLURAL.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendMinutes().appendSuffix(EText.LONG_MINUTE_SINGULAR.getDisplayText(locale), EText.LONG_MINUTE_PLURAL.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendSeconds().appendSuffix(EText.LONG_SECOND_SINGULAR.getDisplayText(locale), EText.LONG_SECOND_PLURAL.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendMillis().appendSuffix(EText.LONG_MILLISECOND_SINGULAR.getDisplayText(locale), EText.LONG_MILLISECOND_PLURAL.getDisplayText(locale)).toFormatter();
    }

    @Nonnull
    public static PeriodFormatter getFormatterShort(@Nonnull Locale locale) {
        String string = EText.LONG_SEPARATOR_FRONT.getDisplayText(locale);
        String string2 = EText.LONG_SEPARATOR_LAST.getDisplayText(locale);
        String[] stringArray = PeriodFormatMultilingual._getSeparatorVariants(locale);
        return new PeriodFormatterBuilder().appendYears().appendSuffix(EText.SHORT_YEAR.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendMonths().appendSuffix(EText.SHORT_MONTH.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendWeeks().appendSuffix(EText.SHORT_WEEK.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendDays().appendSuffix(EText.SHORT_DAY.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendHours().appendSuffix(EText.SHORT_HOUR.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendMinutes().appendSuffix(EText.SHORT_MINUTE.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendSeconds().appendSuffix(EText.SHORT_SECOND.getDisplayText(locale)).appendSeparator(string, string2, stringArray).appendMillis().appendSuffix(EText.SHORT_MILLISECOND.getDisplayText(locale)).toFormatter();
    }

    @Nonnull
    public static PeriodFormatter getFormatterVeryShort(@Nonnull Locale locale) {
        String[] stringArray = new String[]{" ", ",", ", "};
        return new PeriodFormatterBuilder().appendYears().appendSuffix(EText.SHORT_YEAR.getDisplayText(locale)).appendSeparator(" ", " ", stringArray).appendMonths().appendSuffix(EText.SHORT_MONTH.getDisplayText(locale)).appendSeparator(" ", " ", stringArray).appendWeeks().appendSuffix(EText.SHORT_WEEK.getDisplayText(locale)).appendSeparator(" ", " ", stringArray).appendDays().appendSuffix(EText.SHORT_DAY.getDisplayText(locale)).appendSeparator(" ", " ", stringArray).appendHours().appendSuffix(EText.SHORT_HOUR.getDisplayText(locale)).appendSeparator(" ", " ", stringArray).appendMinutes().appendSuffix(EText.SHORT_MINUTE.getDisplayText(locale)).appendSeparator(" ", " ", stringArray).appendSeconds().appendSuffix(EText.SHORT_SECOND.getDisplayText(locale)).appendSeparator(" ", " ", stringArray).appendMillis().appendSuffix(EText.SHORT_MILLISECOND.getDisplayText(locale)).toFormatter();
    }

    @Translatable
    private static enum EText implements IHasDisplayText
    {
        LONG_YEAR_SINGULAR(" Jahr", " year"),
        LONG_YEAR_PLURAL(" Jahre", " years"),
        LONG_MONTH_SINGULAR(" Monat", " month"),
        LONG_MONTH_PLURAL(" Monate", " month"),
        LONG_WEEK_SINGULAR(" Woche", " week"),
        LONG_WEEK_PLURAL(" Wochen", " weeks"),
        LONG_DAY_SINGULAR(" Tag", " day"),
        LONG_DAY_PLURAL(" Tage", " days"),
        LONG_HOUR_SINGULAR(" Stunde", " hours"),
        LONG_HOUR_PLURAL(" Stunden", " hours"),
        LONG_MINUTE_SINGULAR(" Minute", " minute"),
        LONG_MINUTE_PLURAL(" Minuten", " minutes"),
        LONG_SECOND_SINGULAR(" Sekunde", " second"),
        LONG_SECOND_PLURAL(" Sekunden", " seconds"),
        LONG_MILLISECOND_SINGULAR(" Millisekunde", " millisecond"),
        LONG_MILLISECOND_PLURAL(" Millisekunden", " millisecond"),
        LONG_SEPARATOR_FRONT(", ", ", "),
        LONG_SEPARATOR_LAST(" und ", " and "),
        SHORT_YEAR(" J", " y"),
        SHORT_MONTH(" M", " m"),
        SHORT_WEEK(" W", " w"),
        SHORT_DAY(" T", " d"),
        SHORT_HOUR(" Std", " h"),
        SHORT_MINUTE(" Min", " min"),
        SHORT_SECOND(" Sek", " sec"),
        SHORT_MILLISECOND(" Millisek", " millisec");

        private final TextProvider m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextProvider.create_DE_EN((String)string2, (String)string3);
        }

        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getText((Enum)this, (ITextProvider)this.m_aTP, (Locale)locale);
        }
    }
}

