/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.format.PDTFormatter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class SerializableDateTimeFormatter
implements Serializable {
    private static final long serialVersionUID = 582607745264511789L;
    private transient DateTimeFormatter m_aFormatter;
    private EFormatStyle m_eDateStyle;
    private EFormatStyle m_eTimeStyle;
    private Locale m_aLocale;
    private String m_sPattern;

    private SerializableDateTimeFormatter(@Nonnull DateTimeFormatter dateTimeFormatter, @Nullable EFormatStyle eFormatStyle, @Nullable EFormatStyle eFormatStyle2, @Nullable String string, @Nullable Locale locale) {
        if (dateTimeFormatter == null) {
            throw new NullPointerException("formatter");
        }
        if (eFormatStyle == null && eFormatStyle2 == null && string == null) {
            throw new IllegalArgumentException("At least on descriptor must be present!");
        }
        if (eFormatStyle != null && eFormatStyle2 == null || eFormatStyle == null && eFormatStyle2 != null) {
            throw new IllegalArgumentException("Either both or no date and time style must be present!");
        }
        this.m_aFormatter = dateTimeFormatter;
        this.m_eDateStyle = eFormatStyle;
        this.m_eTimeStyle = eFormatStyle2;
        this.m_sPattern = string;
        this.m_aLocale = locale;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject((Object)this.m_eDateStyle);
        objectOutputStream.writeObject((Object)this.m_eTimeStyle);
        objectOutputStream.writeObject(this.m_sPattern);
        objectOutputStream.writeObject(this.m_aLocale);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_eDateStyle = (EFormatStyle)((Object)objectInputStream.readObject());
        this.m_eTimeStyle = (EFormatStyle)((Object)objectInputStream.readObject());
        this.m_sPattern = (String)objectInputStream.readObject();
        this.m_aLocale = (Locale)objectInputStream.readObject();
        if (this.m_eDateStyle != null && this.m_eTimeStyle != null) {
            this.m_aFormatter = SerializableDateTimeFormatter._createFormatter(this.m_eDateStyle, this.m_eTimeStyle, this.m_aLocale);
        } else if (this.m_sPattern != null) {
            this.m_aFormatter = SerializableDateTimeFormatter._createFormatter(this.m_sPattern, this.m_aLocale);
        } else {
            throw new IllegalStateException("Don't know how to revuild the formatter from " + (Object)((Object)this.m_eDateStyle) + "/" + (Object)((Object)this.m_eTimeStyle) + "/" + this.m_sPattern + "/" + this.m_aLocale);
        }
    }

    @Nonnull
    public DateTimeFormatter getFormatter() {
        return this.m_aFormatter;
    }

    @Nullable
    public EFormatStyle getDateStyle() {
        return this.m_eDateStyle;
    }

    @Nullable
    public EFormatStyle getTimeStyle() {
        return this.m_eTimeStyle;
    }

    @Nullable
    public String getPattern() {
        return this.m_sPattern;
    }

    @Nullable
    public Locale getLocale() {
        return this.m_aLocale;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SerializableDateTimeFormatter)) {
            return false;
        }
        SerializableDateTimeFormatter serializableDateTimeFormatter = (SerializableDateTimeFormatter)object;
        return EqualsUtils.equals((Object)((Object)this.m_eDateStyle), (Object)((Object)serializableDateTimeFormatter.m_eDateStyle)) && EqualsUtils.equals((Object)((Object)this.m_eTimeStyle), (Object)((Object)serializableDateTimeFormatter.m_eTimeStyle)) && EqualsUtils.equals((Object)this.m_sPattern, (Object)serializableDateTimeFormatter.m_sPattern) && EqualsUtils.equals((Object)this.m_aLocale, (Object)serializableDateTimeFormatter.m_aLocale);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eDateStyle).append((Enum)this.m_eTimeStyle).append((Object)this.m_sPattern).append((Object)this.m_aLocale).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("dateStyle", (Enum)this.m_eDateStyle).append("timeStyle", (Enum)this.m_eTimeStyle).append("pattern", (Object)this.m_sPattern).append("locale", (Object)this.m_aLocale).toString();
    }

    @Nonnull
    private static DateTimeFormatter _createFormatter(@Nonnull EFormatStyle eFormatStyle, @Nonnull EFormatStyle eFormatStyle2, @Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.forStyle((String)(eFormatStyle.getStyleString() + eFormatStyle2.getStyleString())), locale);
    }

    @Nonnull
    private static DateTimeFormatter _createFormatter(@Nonnull String string, @Nullable Locale locale) {
        return PDTFormatter.getWithLocaleAndChrono(DateTimeFormat.forPattern((String)string), locale);
    }

    @Nonnull
    public static SerializableDateTimeFormatter createForDate(@Nonnull EFormatStyle eFormatStyle) {
        return SerializableDateTimeFormatter.createForDate(eFormatStyle, null);
    }

    @Nonnull
    public static SerializableDateTimeFormatter createForDate(@Nonnull EFormatStyle eFormatStyle, @Nullable Locale locale) {
        return SerializableDateTimeFormatter.create(eFormatStyle, EFormatStyle.NONE, locale);
    }

    @Nonnull
    public static SerializableDateTimeFormatter createForTime(@Nonnull EFormatStyle eFormatStyle) {
        return SerializableDateTimeFormatter.createForTime(eFormatStyle, null);
    }

    @Nonnull
    public static SerializableDateTimeFormatter createForTime(@Nonnull EFormatStyle eFormatStyle, @Nullable Locale locale) {
        return SerializableDateTimeFormatter.create(EFormatStyle.NONE, eFormatStyle, locale);
    }

    @Nonnull
    public static SerializableDateTimeFormatter create(@Nonnull EFormatStyle eFormatStyle, @Nonnull EFormatStyle eFormatStyle2) {
        return SerializableDateTimeFormatter.create(eFormatStyle, eFormatStyle2, null);
    }

    @Nonnull
    public static SerializableDateTimeFormatter create(@Nonnull EFormatStyle eFormatStyle, @Nonnull EFormatStyle eFormatStyle2, @Nullable Locale locale) {
        if (eFormatStyle == null) {
            throw new NullPointerException("dateStyle");
        }
        if (eFormatStyle2 == null) {
            throw new NullPointerException("timeStyle");
        }
        return new SerializableDateTimeFormatter(SerializableDateTimeFormatter._createFormatter(eFormatStyle, eFormatStyle2, locale), eFormatStyle, eFormatStyle2, null, locale);
    }

    @Nonnull
    public static SerializableDateTimeFormatter create(@Nonnull String string) {
        return SerializableDateTimeFormatter.create(string, null);
    }

    @Nonnull
    public static SerializableDateTimeFormatter create(@Nonnull String string, @Nullable Locale locale) throws IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        return new SerializableDateTimeFormatter(SerializableDateTimeFormatter._createFormatter(string, locale), null, null, string, locale);
    }

    public static enum EFormatStyle {
        SHORT("S", 3),
        MEDIUM("M", 2),
        LONG("L", 1),
        FULL("F", 0),
        NONE("-", 4);

        public static final EFormatStyle DEFAULT;
        private String m_sFormat;
        private int m_nFormat;

        private EFormatStyle(String string2, int n2) {
            this.m_sFormat = string2;
            this.m_nFormat = n2;
        }

        public String getStyleString() {
            return this.m_sFormat;
        }

        public int getStyleInt() {
            return this.m_nFormat;
        }

        static {
            DEFAULT = MEDIUM;
        }
    }
}

