/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.io;

import com.helger.datetime.PDTFactory;
import com.helger.datetime.format.PDTToString;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

@Immutable
public final class PDTIOHelper {
    public static final String PATTERN_DATE = "yyyyMMdd";
    public static final String PATTERN_TIME = "HHmmss";
    public static final String PATTERN_DATETIME = "yyyyMMdd_HHmmss";
    private static final PDTIOHelper s_aInstance = new PDTIOHelper();

    private PDTIOHelper() {
    }

    @Nonnull
    public static String getCurrentDateTimeForFilename() {
        return PDTIOHelper.getDateTimeForFilename(PDTFactory.getCurrentDateTime());
    }

    @Nonnull
    public static String getDateTimeForFilename(@Nonnull DateTime dateTime) {
        return PDTToString.getAsString(PATTERN_DATETIME, (ReadableInstant)dateTime);
    }

    @Nonnull
    public static String getCurrentLocalDateTimeForFilename() {
        return PDTIOHelper.getLocalDateTimeForFilename(PDTFactory.getCurrentLocalDateTime());
    }

    @Nonnull
    public static String getLocalDateTimeForFilename(@Nonnull LocalDateTime localDateTime) {
        return PDTToString.getAsString(PATTERN_DATETIME, (ReadablePartial)localDateTime);
    }

    public static String getCurrentDateForFilename() {
        return PDTIOHelper.getDateForFilename(PDTFactory.getCurrentLocalDate());
    }

    public static String getDateForFilename(@Nonnull LocalDate localDate) {
        return PDTToString.getAsString(PATTERN_DATE, (ReadablePartial)localDate);
    }

    public static String getCurrentTimeForFilename() {
        return PDTIOHelper.getTimeForFilename(PDTFactory.getCurrentLocalTime());
    }

    public static String getTimeForFilename(@Nonnull LocalTime localTime) {
        return PDTToString.getAsString(PATTERN_TIME, (ReadablePartial)localTime);
    }
}

