/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.period;

import com.helger.datetime.PDTFactory;
import com.helger.datetime.period.AbstractFlexiblePeriod;
import com.helger.datetime.period.IDateTimePeriod;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

@NotThreadSafe
public class DateTimePeriod
extends AbstractFlexiblePeriod<DateTime>
implements IDateTimePeriod {
    public DateTimePeriod() {
        this(null, null);
    }

    public DateTimePeriod(@Nullable DateTime dateTime) {
        this(dateTime, null);
    }

    public DateTimePeriod(@Nullable DateTime dateTime, @Nullable DateTime dateTime2) {
        super(dateTime, dateTime2);
    }

    @Override
    public final boolean isValidFor(@Nonnull DateTime dateTime) {
        if (dateTime == null) {
            throw new NullPointerException("date");
        }
        DateTime dateTime2 = (DateTime)this.getStart();
        if (dateTime2 != null && dateTime2.isAfter((ReadableInstant)dateTime)) {
            return false;
        }
        DateTime dateTime3 = (DateTime)this.getEnd();
        return dateTime3 == null || !dateTime3.isBefore((ReadableInstant)dateTime);
    }

    @Override
    public final boolean isValidForNow() {
        return this.isValidFor(PDTFactory.getCurrentDateTime());
    }

    @Override
    public boolean canConvertToPeriod() {
        return this.getStart() != null && this.getEnd() != null;
    }

    @Override
    @Nonnull
    public final Period getAsPeriod() {
        if (!this.canConvertToPeriod()) {
            throw new IllegalStateException("Cannot convert to a Period!");
        }
        return new Period((ReadableInstant)this.getStart(), (ReadableInstant)this.getEnd());
    }

    @Override
    public boolean canConvertToInterval() {
        return this.getStart() != null && this.getEnd() != null;
    }

    @Override
    @Nonnull
    public Interval getAsInterval() {
        if (!this.canConvertToInterval()) {
            throw new IllegalStateException("Cannot convert to an Interval!");
        }
        return new Interval((ReadableInstant)this.getStart(), (ReadableInstant)this.getEnd());
    }
}

