/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.period;

import com.helger.datetime.PDTFactory;
import com.helger.datetime.period.AbstractFlexiblePeriod;
import com.helger.datetime.period.ILocalDatePeriod;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;

@NotThreadSafe
public class LocalDatePeriod
extends AbstractFlexiblePeriod<LocalDate>
implements ILocalDatePeriod {
    public LocalDatePeriod() {
        this(null, null);
    }

    public LocalDatePeriod(@Nullable LocalDate localDate) {
        this(localDate, null);
    }

    public LocalDatePeriod(@Nullable LocalDate localDate, @Nullable LocalDate localDate2) {
        super(localDate, localDate2);
    }

    @Override
    public final boolean isValidFor(@Nonnull LocalDate localDate) {
        if (localDate == null) {
            throw new NullPointerException("date");
        }
        LocalDate localDate2 = (LocalDate)this.getStart();
        if (localDate2 != null && localDate2.isAfter((ReadablePartial)localDate)) {
            return false;
        }
        LocalDate localDate3 = (LocalDate)this.getEnd();
        return localDate3 == null || !localDate3.isBefore((ReadablePartial)localDate);
    }

    @Override
    public final boolean isValidForNow() {
        return this.isValidFor(PDTFactory.getCurrentLocalDate());
    }

    @Override
    public boolean canConvertToPeriod() {
        return this.getStart() != null && this.getEnd() != null;
    }

    @Override
    @Nonnull
    public final Period getAsPeriod() {
        if (!this.canConvertToPeriod()) {
            throw new IllegalStateException("Cannot convert to a Period!");
        }
        return new Period((ReadablePartial)this.getStart(), (ReadablePartial)this.getEnd());
    }
}

