/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.period;

import com.helger.datetime.PDTFactory;
import com.helger.datetime.period.AbstractFlexiblePeriod;
import com.helger.datetime.period.ILocalDateTimePeriod;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;

@NotThreadSafe
public class LocalDateTimePeriod
extends AbstractFlexiblePeriod<LocalDateTime>
implements ILocalDateTimePeriod {
    public LocalDateTimePeriod() {
        this(null, null);
    }

    public LocalDateTimePeriod(@Nullable LocalDateTime localDateTime) {
        this(localDateTime, null);
    }

    public LocalDateTimePeriod(@Nullable LocalDateTime localDateTime, @Nullable LocalDateTime localDateTime2) {
        super(localDateTime, localDateTime2);
    }

    @Override
    public final boolean isValidFor(@Nonnull LocalDateTime localDateTime) {
        if (localDateTime == null) {
            throw new NullPointerException("date");
        }
        LocalDateTime localDateTime2 = (LocalDateTime)this.getStart();
        if (localDateTime2 != null && localDateTime2.isAfter((ReadablePartial)localDateTime)) {
            return false;
        }
        LocalDateTime localDateTime3 = (LocalDateTime)this.getEnd();
        return localDateTime3 == null || !localDateTime3.isBefore((ReadablePartial)localDateTime);
    }

    @Override
    public final boolean isValidForNow() {
        return this.isValidFor(PDTFactory.getCurrentLocalDateTime());
    }

    @Override
    public boolean canConvertToPeriod() {
        return this.getStart() != null && this.getEnd() != null;
    }

    @Override
    @Nonnull
    public final Period getAsPeriod() {
        if (!this.canConvertToPeriod()) {
            throw new IllegalStateException("Cannot convert to a Period!");
        }
        return new Period((ReadablePartial)this.getStart(), (ReadablePartial)this.getEnd());
    }
}

