/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.period;

import com.helger.datetime.PDTFactory;
import com.helger.datetime.period.AbstractFlexiblePeriod;
import com.helger.datetime.period.ILocalTimePeriod;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;

@NotThreadSafe
public class LocalTimePeriod
extends AbstractFlexiblePeriod<LocalTime>
implements ILocalTimePeriod {
    public LocalTimePeriod() {
        this(null, null);
    }

    public LocalTimePeriod(@Nullable LocalTime localTime) {
        this(localTime, null);
    }

    public LocalTimePeriod(@Nullable LocalTime localTime, @Nullable LocalTime localTime2) {
        super(localTime, localTime2);
    }

    @Override
    public final boolean isValidFor(@Nonnull LocalTime localTime) {
        if (localTime == null) {
            throw new NullPointerException("date");
        }
        LocalTime localTime2 = (LocalTime)this.getStart();
        if (localTime2 != null && localTime2.isAfter((ReadablePartial)localTime)) {
            return false;
        }
        LocalTime localTime3 = (LocalTime)this.getEnd();
        return localTime3 == null || !localTime3.isBefore((ReadablePartial)localTime);
    }

    @Override
    public final boolean isValidForNow() {
        return this.isValidFor(PDTFactory.getCurrentLocalTime());
    }

    @Override
    public boolean canConvertToPeriod() {
        return this.getStart() != null && this.getEnd() != null;
    }

    @Override
    @Nonnull
    public final Period getAsPeriod() {
        if (!this.canConvertToPeriod()) {
            throw new IllegalStateException("Cannot convert to a Period!");
        }
        return new Period((ReadablePartial)this.getStart(), (ReadablePartial)this.getEnd());
    }
}

