/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.xml;

import com.helger.commons.exceptions.InitializationException;
import com.helger.datetime.PDTFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PDTXMLConverter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDTXMLConverter.class);
    private static final DatatypeFactory s_aDTFactory;
    private static final PDTXMLConverter s_aInstance;

    private PDTXMLConverter() {
    }

    public static int getTimezoneOffsetInMinutes(@Nonnull Calendar calendar) {
        int n = calendar.getTimeZone().getOffset(calendar.getTimeInMillis());
        return n / 60000;
    }

    @Nonnull
    public static GregorianCalendar getCalendar(@Nonnull Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    @Nonnull
    public static GregorianCalendar getCalendar(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        return gregorianCalendar;
    }

    @Nonnull
    public static XMLGregorianCalendar createNewCalendar() {
        return s_aDTFactory.newXMLGregorianCalendar();
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarDateNow() {
        return PDTXMLConverter.getXMLCalendarDate(PDTFactory.getCurrentLocalDate());
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarDate(@Nullable LocalDate localDate) {
        return localDate == null ? null : s_aDTFactory.newXMLGregorianCalendarDate(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth(), Integer.MIN_VALUE);
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarDate(@Nullable Date date) {
        return date == null ? null : PDTXMLConverter.getXMLCalendarDate(PDTXMLConverter.getCalendar(date));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarDate(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : s_aDTFactory.newXMLGregorianCalendarDate(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), PDTXMLConverter.getTimezoneOffsetInMinutes(gregorianCalendar));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        return xMLGregorianCalendar == null ? null : s_aDTFactory.newXMLGregorianCalendarDate(xMLGregorianCalendar.getYear(), xMLGregorianCalendar.getMonth(), xMLGregorianCalendar.getDay(), xMLGregorianCalendar.getTimezone() == 0 ? Integer.MIN_VALUE : xMLGregorianCalendar.getTimezone());
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarDate(int n, int n2, int n3) {
        return PDTXMLConverter.getXMLCalendarDate(n, n2, n3, Integer.MIN_VALUE);
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarDate(int n, int n2, int n3, int n4) {
        return s_aDTFactory.newXMLGregorianCalendarDate(n, n2, n3, n4);
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarTimeNow() {
        return PDTXMLConverter.getXMLCalendarTime(PDTFactory.getCurrentLocalTime());
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarTime(@Nullable LocalTime localTime) {
        return localTime == null ? null : s_aDTFactory.newXMLGregorianCalendarTime(localTime.getHourOfDay(), localTime.getMinuteOfHour(), localTime.getSecondOfMinute(), localTime.getMillisOfSecond(), Integer.MIN_VALUE);
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarTime(@Nullable Date date) {
        return date == null ? null : PDTXMLConverter.getXMLCalendarTime(PDTXMLConverter.getCalendar(date));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : s_aDTFactory.newXMLGregorianCalendarTime(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14), PDTXMLConverter.getTimezoneOffsetInMinutes(gregorianCalendar));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        return xMLGregorianCalendar == null ? null : s_aDTFactory.newXMLGregorianCalendarTime(xMLGregorianCalendar.getHour(), xMLGregorianCalendar.getMinute(), xMLGregorianCalendar.getSecond(), xMLGregorianCalendar.getMillisecond(), xMLGregorianCalendar.getTimezone());
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarTime(int n, int n2, int n3, int n4) {
        return PDTXMLConverter.getXMLCalendarTime(n, n2, n3, n4, Integer.MIN_VALUE);
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarTime(int n, int n2, int n3, int n4, int n5) {
        return s_aDTFactory.newXMLGregorianCalendarTime(n, n2, n3, n4, n5);
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarNow() {
        return PDTXMLConverter.getXMLCalendar(PDTFactory.getCurrentDateTime());
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarNowUTC() {
        return PDTXMLConverter.getXMLCalendar(PDTFactory.getCurrentDateTimeUTC());
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendar(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : s_aDTFactory.newXMLGregorianCalendar(localDateTime.getYear(), localDateTime.getMonthOfYear(), localDateTime.getDayOfMonth(), localDateTime.getHourOfDay(), localDateTime.getMinuteOfHour(), localDateTime.getSecondOfMinute(), localDateTime.getMillisOfSecond(), Integer.MIN_VALUE);
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendar(@Nullable DateTime dateTime) {
        return dateTime == null ? null : s_aDTFactory.newXMLGregorianCalendar(dateTime.toGregorianCalendar());
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendar(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : s_aDTFactory.newXMLGregorianCalendar(gregorianCalendar);
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendar(@Nullable XMLGregorianCalendar xMLGregorianCalendar, @Nullable XMLGregorianCalendar xMLGregorianCalendar2) {
        if (xMLGregorianCalendar == null && xMLGregorianCalendar2 == null) {
            return null;
        }
        if (xMLGregorianCalendar2 == null) {
            return s_aDTFactory.newXMLGregorianCalendar(xMLGregorianCalendar.getYear(), xMLGregorianCalendar.getMonth(), xMLGregorianCalendar.getDay(), 0, 0, 0, 0, xMLGregorianCalendar.getTimezone());
        }
        if (xMLGregorianCalendar == null) {
            return s_aDTFactory.newXMLGregorianCalendar(0, 0, 0, xMLGregorianCalendar2.getHour(), xMLGregorianCalendar2.getMinute(), xMLGregorianCalendar2.getSecond(), xMLGregorianCalendar2.getMillisecond(), xMLGregorianCalendar2.getTimezone());
        }
        if (xMLGregorianCalendar.getTimezone() != xMLGregorianCalendar2.getTimezone()) {
            s_aLogger.warn("Date and time have different timezones: " + xMLGregorianCalendar.getTimezone() + " vs. " + xMLGregorianCalendar2.getTimezone());
        }
        return s_aDTFactory.newXMLGregorianCalendar(xMLGregorianCalendar.getYear(), xMLGregorianCalendar.getMonth(), xMLGregorianCalendar.getDay(), xMLGregorianCalendar2.getHour(), xMLGregorianCalendar2.getMinute(), xMLGregorianCalendar2.getSecond(), xMLGregorianCalendar2.getMillisecond(), xMLGregorianCalendar.getTimezone());
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendar(long l) {
        return s_aDTFactory.newXMLGregorianCalendar(PDTXMLConverter.getCalendar(l));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendar(@Nullable Date date) {
        return date == null ? null : s_aDTFactory.newXMLGregorianCalendar(PDTXMLConverter.getCalendar(date));
    }

    @Nullable
    public static GregorianCalendar getGregorianCalendar(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        return xMLGregorianCalendar == null ? null : xMLGregorianCalendar.toGregorianCalendar(xMLGregorianCalendar.getTimeZone(xMLGregorianCalendar.getTimezone()), null, null);
    }

    @Nullable
    public static LocalDate getLocalDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        return xMLGregorianCalendar == null ? null : PDTFactory.createLocalDate(PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar));
    }

    @Nullable
    public static LocalTime getLocalTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        return xMLGregorianCalendar == null ? null : PDTFactory.createLocalTime(PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar));
    }

    @Nullable
    public static LocalDateTime getLocalDateTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        return xMLGregorianCalendar == null ? null : PDTFactory.createLocalDateTime(PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar));
    }

    @Nullable
    public static DateTime getDateTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        return xMLGregorianCalendar == null ? null : PDTFactory.createDateTime(PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar));
    }

    @Nullable
    public static Date getDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        GregorianCalendar gregorianCalendar = PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar);
        return gregorianCalendar == null ? null : gregorianCalendar.getTime();
    }

    @CheckForSigned
    public static long getMillis(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        GregorianCalendar gregorianCalendar = PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar);
        return gregorianCalendar == null ? -1L : gregorianCalendar.getTimeInMillis();
    }

    static {
        try {
            s_aDTFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new InitializationException("Failed to init DataTypeFactory", (Throwable)datatypeConfigurationException);
        }
        s_aInstance = new PDTXMLConverter();
    }
}

