/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.id.factory.IIDFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class GraphObjectIDFactory {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static IIDFactory<String> s_aIDFactory;
    private static final GraphObjectIDFactory s_aInstance;

    private GraphObjectIDFactory() {
    }

    @Nullable
    public static IIDFactory<String> getIDFactory() {
        return (IIDFactory)s_aRWLock.readLockedGet(() -> s_aIDFactory);
    }

    public static void setIDFactory(@Nullable IIDFactory<String> iIDFactory) {
        s_aRWLock.writeLockedGet(() -> {
            s_aIDFactory = iIDFactory;
            return s_aIDFactory;
        });
    }

    @Nonnull
    @Nonempty
    public static String createNewGraphObjectID() {
        return (String)s_aRWLock.readLockedGet(() -> s_aIDFactory != null ? (String)s_aIDFactory.getNewID() : GlobalIDFactory.getNewStringID());
    }

    static {
        s_aInstance = new GraphObjectIDFactory();
    }
}

