/**
 * Copyright (C) 2014-2015 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.masterdata.locale;

import static org.junit.Assert.assertTrue;

import org.junit.Test;

/**
 * Test class for class {@link ContinentUtils}.
 * 
 * @author Philip Helger
 */
public class ContinentUtilsTest
{
  @Test
  public void testBasic ()
  {
    assertTrue (ContinentUtils.getContinentsOfCountry ("DE").contains (EContinent.EUROPE));
    assertTrue (ContinentUtils.getContinentsOfCountry ("AT").contains (EContinent.EUROPE));
    assertTrue (ContinentUtils.getContinentsOfCountry ("AO").contains (EContinent.AFRICA));
    assertTrue (ContinentUtils.getContinentsOfCountry ("CN").contains (EContinent.ASIA));
    // No continent specified
    assertTrue (ContinentUtils.getContinentsOfCountry ("BV").contains (EContinent.UNDEFINED));
  }
}
