/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.dns;

import com.helger.network.dns.IPV4Addr;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

@Immutable
public final class DNSResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNSResolver.class);
    private static final DNSResolver s_aInstance = new DNSResolver();

    private DNSResolver() {
    }

    @Nullable
    public static InetAddress resolveByName(@Nonnull String string) {
        try {
            return Address.getByName((String)string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Nullable
    public static String dnsResolve(@Nonnull String string) {
        InetAddress inetAddress = DNSResolver.resolveByName(string);
        if (inetAddress == null) {
            return null;
        }
        return new IPV4Addr(inetAddress.getAddress()).getAsString();
    }

    @Nonnull
    public static String dnsResolveEx(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            InetAddress[] inetAddressArray;
            for (InetAddress inetAddress : inetAddressArray = InetAddress.getAllByName(string)) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(inetAddress.getHostAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            LOGGER.error("DNS name not resolvable " + string, (Throwable)unknownHostException);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getMyIpAddress() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null) {
                return new IPV4Addr(inetAddress.getAddress()).getAsString();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "127.0.0.1";
    }
}

