/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.port;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.network.port.NetworkPortHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class SchemeDefaultPortMapper {
    public static final String SCHEME_FTP = "ftp";
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    private static final SchemeDefaultPortMapper s_aInstance = new SchemeDefaultPortMapper();
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<String, Integer> s_aMap = new CommonsHashMap();

    private SchemeDefaultPortMapper() {
    }

    public static void registerDefaultPort(@Nonnull @Nonempty String string, @Nonnegative int n) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SchemeName");
        ValueEnforcer.isTrue((boolean)NetworkPortHelper.isValidPort(n), (String)"Invalid port provided");
        s_aRWLock.writeLocked(() -> {
            if (s_aMap.containsKey((Object)string)) {
                throw new IllegalArgumentException("A default port for scheme '" + string + "' is already registered!");
            }
            s_aMap.put((Object)string, (Object)n);
        });
    }

    public static int getDefaultPort(@Nullable String string, int n) {
        Integer n2;
        if (StringHelper.hasText((String)string) && (n2 = (Integer)s_aRWLock.readLocked(() -> (Integer)s_aMap.get((Object)string))) != null) {
            return n2;
        }
        return n;
    }

    public static int getDefaultPortOrInvalid(@Nullable String string) {
        return SchemeDefaultPortMapper.getDefaultPort(string, -1);
    }

    public static int getDefaultPortOrThrow(@Nullable String string) {
        int n = SchemeDefaultPortMapper.getDefaultPortOrInvalid(string);
        if (n == -1) {
            throw new IllegalArgumentException("No default port present for scheme '" + string + "'");
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, Integer> getAll() {
        return (ICommonsMap)s_aRWLock.readLocked(() -> s_aMap.getClone());
    }

    static {
        SchemeDefaultPortMapper.registerDefaultPort(SCHEME_FTP, 21);
        SchemeDefaultPortMapper.registerDefaultPort(SCHEME_HTTP, 80);
        SchemeDefaultPortMapper.registerDefaultPort(SCHEME_HTTPS, 443);
    }
}

