/**
 * Copyright (C) 2014-2015 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.photon.basic.app.systemmsg;

import java.util.Locale;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasDisplayText;

/**
 * This enumeration defines the different system message types.
 *
 * @author Philip Helger
 */
public enum ESystemMessageType implements IHasID <String>, IHasDisplayText
{
  INFO ("i", ESystemMessageTypeText.INFO),
  WARNING ("w", ESystemMessageTypeText.WARNING),
  ERROR ("e", ESystemMessageTypeText.ERROR),
  SUCCESS ("s", ESystemMessageTypeText.SUCCESS);

  public static final ESystemMessageType DEFAULT = INFO;

  private final String m_sID;
  private final ESystemMessageTypeText m_eText;

  private ESystemMessageType (@Nonnull @Nonempty final String sID, @Nonnull final ESystemMessageTypeText aText)
  {
    m_sID = sID;
    m_eText = aText;
  }

  @Nonnull
  @Nonempty
  public String getID ()
  {
    return m_sID;
  }

  @Nullable
  public String getDisplayText (@Nonnull final Locale aContentLocale)
  {
    return m_eText.getDisplayText (aContentLocale);
  }

  @Nonnull
  public static ESystemMessageType getFromIDOrDefault (@Nullable final String sID)
  {
    return EnumHelper.getFromIDOrDefault (ESystemMessageType.class, sID, DEFAULT);
  }
}
