/**
 * Copyright (C) 2014-2015 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.photon.basic.atom;

import javax.annotation.Nonnull;
import javax.xml.XMLConstants;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.impl.MicroElement;
import com.helger.commons.string.StringHelper;
import com.helger.html.CHTMLDocTypes;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.conversion.HCConversionSettings;
import com.helger.html.hc.conversion.HCSettings;
import com.helger.html.hc.html.HCDiv;

public abstract class AbstractFeedXHTML extends AbstractFeedElement
{
  // Feed XML always as XHTML 1.1
  private static final HCConversionSettings HCCONV_SETTINGS = new HCConversionSettings (HCSettings.getConversionSettings (),
                                                                                        EHTMLVersion.XHTML11).setToOptimized ();

  private final HCDiv m_aDiv;

  public AbstractFeedXHTML (@Nonnull final HCDiv aDiv)
  {
    ValueEnforcer.notNull (aDiv, "Div");
    m_aDiv = aDiv;
  }

  @Nonnull
  @Nonempty
  public final String getType ()
  {
    return EFeedTextType.XHTML.getType ();
  }

  @Nonnull
  public final HCDiv getDIV ()
  {
    return m_aDiv;
  }

  public final IMicroElement getAsElement (final String sElementName)
  {
    final IMicroElement aElement = new MicroElement (CFeed.XMLNS_ATOM, sElementName);
    aElement.setAttribute ("type", getType ());
    {
      final IMicroNode aDivNode = m_aDiv.convertToNode (HCCONV_SETTINGS);
      ((IMicroElement) aDivNode).setNamespaceURI (CHTMLDocTypes.DOCTYPE_XHTML_URI);
      aElement.appendChild (aDivNode);
    }
    if (StringHelper.hasText (getLanguage ()))
      aElement.setAttribute (XMLConstants.XML_NS_URI, "lang", getLanguage ());
    return aElement;
  }

  public final boolean isValid ()
  {
    return true;
  }
}
