/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4;

import com.helger.commons.state.EChange;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.EHCInputType;
import com.helger.html.hc.html.forms.HCCtrlHelper;
import com.helger.html.hc.html.forms.IHCControl;
import com.helger.html.hc.html.forms.IHCInput;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class BootstrapHelper {
    private static final BootstrapHelper s_aInstance = new BootstrapHelper();

    private BootstrapHelper() {
    }

    @Nonnull
    public static EChange markAsFormControl(@Nullable IHCControl<?> iHCControl) {
        if (iHCControl != null) {
            ICSSClassProvider iCSSClassProvider = CBootstrapCSS.FORM_CONTROL;
            if (iHCControl instanceof IHCInput) {
                IHCInput iHCInput = (IHCInput)iHCControl;
                EHCInputType eHCInputType = iHCInput.getType();
                switch (eHCInputType) {
                    case CHECKBOX: 
                    case RADIO: {
                        iCSSClassProvider = CBootstrapCSS.FORM_CHECK_INPUT;
                        break;
                    }
                    case FILE: {
                        iCSSClassProvider = CBootstrapCSS.FORM_CONTROL_FILE;
                        break;
                    }
                    case HIDDEN: {
                        iCSSClassProvider = null;
                    }
                }
            }
            if (iCSSClassProvider != null) {
                iHCControl.addClass(iCSSClassProvider);
                return EChange.CHANGED;
            }
        }
        return EChange.UNCHANGED;
    }

    public static void markAsFormControls(@Nullable Iterable<? extends IHCControl<?>> iterable) {
        if (iterable != null) {
            for (IHCControl<?> iHCControl : iterable) {
                BootstrapHelper.markAsFormControl(iHCControl);
            }
        }
    }

    public static void markChildrenAsFormControls(@Nullable IHCNode iHCNode2) {
        if (iHCNode2 != null) {
            iHCNode2.forAllChildren(iHCNode -> BootstrapHelper.markAsFormControls(HCCtrlHelper.getAllHCControls((IHCNode)iHCNode)));
        }
    }
}

