/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.ext;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.photon.basic.app.systemmsg.ESystemMessageType;
import com.helger.photon.basic.app.systemmsg.SystemMessageManager;
import com.helger.photon.basic.mgr.PhotonBasicManager;
import com.helger.photon.bootstrap4.alert.AbstractBootstrapAlert;
import com.helger.photon.bootstrap4.alert.EBootstrapAlertType;
import com.helger.photon.uicore.UITextFormatter;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class BootstrapSystemMessage
extends AbstractBootstrapAlert<BootstrapSystemMessage> {
    public static final BiConsumer<String, BootstrapSystemMessage> FORMATTER_DEFAULT = (string, bootstrapSystemMessage) -> {
        BootstrapSystemMessage cfr_ignored_0 = (BootstrapSystemMessage)bootstrapSystemMessage.addChildren((Iterable)HCExtHelper.nl2divList((String)string));
    };
    public static final BiConsumer<String, BootstrapSystemMessage> FORMATTER_MARKDOWN = (string, bootstrapSystemMessage) -> {
        BootstrapSystemMessage cfr_ignored_0 = (BootstrapSystemMessage)bootstrapSystemMessage.addChild(UITextFormatter.markdown((String)string));
    };
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static BiConsumer<String, BootstrapSystemMessage> s_aFormatter = FORMATTER_DEFAULT;

    @Nonnull
    public static BiConsumer<String, BootstrapSystemMessage> getDefaultFormatter() {
        return (BiConsumer)s_aRWLock.readLocked(() -> s_aFormatter);
    }

    public static void setDefaultFormatter(@Nonnull BiConsumer<String, BootstrapSystemMessage> biConsumer) {
        ValueEnforcer.notNull(biConsumer, (String)"Formatter");
        s_aRWLock.writeLocked(() -> {
            s_aFormatter = biConsumer;
            return s_aFormatter;
        });
    }

    public static void setDefaultUseMarkdown(boolean bl) {
        BootstrapSystemMessage.setDefaultFormatter(bl ? FORMATTER_MARKDOWN : FORMATTER_DEFAULT);
    }

    @Nonnull
    public static EBootstrapAlertType getAlertType(@Nonnull ESystemMessageType eSystemMessageType) {
        switch (eSystemMessageType) {
            case INFO: {
                return EBootstrapAlertType.INFO;
            }
            case WARNING: {
                return EBootstrapAlertType.WARNING;
            }
            case ERROR: {
                return EBootstrapAlertType.DANGER;
            }
            case SUCCESS: {
                return EBootstrapAlertType.SUCCESS;
            }
        }
        throw new IllegalArgumentException("Illegal message type: " + eSystemMessageType);
    }

    protected BootstrapSystemMessage(@Nonnull ESystemMessageType eSystemMessageType) {
        super(BootstrapSystemMessage.getAlertType(eSystemMessageType));
    }

    @Nonnull
    public BootstrapSystemMessage setSystemMessage(@Nullable String string) {
        this.removeAllChildren();
        if (StringHelper.hasText((String)string)) {
            BootstrapSystemMessage.getDefaultFormatter().accept(string, this);
        }
        return this;
    }

    @Nullable
    public static BootstrapSystemMessage createDefault() {
        SystemMessageManager systemMessageManager = PhotonBasicManager.getSystemMessageMgr();
        return BootstrapSystemMessage.create(systemMessageManager.getMessageType(), systemMessageManager.getSystemMessage());
    }

    @Nullable
    public static BootstrapSystemMessage create(@Nonnull ESystemMessageType eSystemMessageType, @Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return new BootstrapSystemMessage(eSystemMessageType).setSystemMessage(string);
    }
}

