/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.form;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.string.StringHelper;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.html.hc.html.forms.AbstractHCCheckBox;
import com.helger.html.hc.html.forms.AbstractHCRadioButton;
import com.helger.html.hc.html.forms.EHCInputType;
import com.helger.html.hc.html.forms.HCCtrlHelper;
import com.helger.html.hc.html.forms.IHCControl;
import com.helger.html.hc.html.forms.IHCInput;
import com.helger.html.hc.html.forms.IHCTextArea;
import com.helger.html.hc.html.grouping.AbstractHCDiv;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.textlevel.HCSmall;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.BootstrapHelper;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.form.BootstrapInvalidFeedback;
import com.helger.photon.bootstrap4.form.EBootstrapFormType;
import com.helger.photon.bootstrap4.form.IBootstrapFormGroupContainer;
import com.helger.photon.bootstrap4.form.IBootstrapFormGroupRenderer;
import com.helger.photon.bootstrap4.grid.BootstrapRow;
import com.helger.photon.uicore.html.formlabel.HCFormLabel;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultBootstrapFormGroupRenderer
implements IBootstrapFormGroupRenderer {
    public static final ICSSClassProvider CSS_CLASS_FORM_GROUP_HELP_TEXT = DefaultCSSClassProvider.create((String)"form-group-help-text");
    public static final ICSSClassProvider CSS_CLASS_FORM_GROUP_ERROR_TEXT = DefaultCSSClassProvider.create((String)"form-group-error-text");
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBootstrapFormGroupRenderer.class);
    private boolean m_bUseIcons = false;
    private boolean m_bForceNoCheckBoxHandling = false;

    @Override
    public boolean isUseIcons() {
        return this.m_bUseIcons;
    }

    @Override
    @Nonnull
    public DefaultBootstrapFormGroupRenderer setUseIcons(boolean bl) {
        this.m_bUseIcons = bl;
        return this;
    }

    public boolean isForceNoCheckBoxHandling() {
        return this.m_bForceNoCheckBoxHandling;
    }

    @Nonnull
    public DefaultBootstrapFormGroupRenderer setForceNoCheckBoxHandling(boolean bl) {
        this.m_bForceNoCheckBoxHandling = bl;
        return this;
    }

    @Nonnull
    private static String _getPlaceholderText(@Nonnull IHCElementWithChildren<?> iHCElementWithChildren) {
        if (iHCElementWithChildren instanceof HCFormLabel) {
            return iHCElementWithChildren.getPlainText();
        }
        String string = StringHelper.trimEnd((String)iHCElementWithChildren.getPlainText(), (String)":");
        string = StringHelper.trimEnd((String)string, (String)"\u00b0");
        string = StringHelper.trimEnd((String)string, (String)"*");
        return string;
    }

    @OverrideOnDemand
    protected void modifyFirstControlIfLabelIsPresent(@Nonnull IHCElementWithChildren<?> iHCElementWithChildren, @Nonnull IHCControl<?> iHCControl) {
        IHCTextArea iHCTextArea;
        if (iHCControl instanceof IHCInput) {
            IHCInput iHCInput = (IHCInput)iHCControl;
            EHCInputType eHCInputType = iHCInput.getType();
            if (eHCInputType != null && eHCInputType.hasPlaceholder() && !iHCInput.hasPlaceholder()) {
                iHCInput.setPlaceholder(DefaultBootstrapFormGroupRenderer._getPlaceholderText(iHCElementWithChildren));
            }
        } else if (iHCControl instanceof IHCTextArea && !(iHCTextArea = (IHCTextArea)iHCControl).hasPlaceholder()) {
            iHCTextArea.setPlaceholder(DefaultBootstrapFormGroupRenderer._getPlaceholderText(iHCElementWithChildren));
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected IHCElementWithChildren<?> createHelpTextNode(@Nonnull IHCNode iHCNode) {
        HCSmall hCSmall = new HCSmall();
        hCSmall.addClass(CBootstrapCSS.FORM_TEXT);
        hCSmall.addClass(CBootstrapCSS.TEXT_MUTED);
        hCSmall.addClass(CSS_CLASS_FORM_GROUP_HELP_TEXT);
        hCSmall.addChild(iHCNode);
        return hCSmall;
    }

    @Nonnull
    public static BootstrapInvalidFeedback createDefaultErrorNode(@Nonnull IError iError, @Nonnull Locale locale) {
        String string;
        String string2 = StringHelper.getNotNull((String)iError.getErrorText(locale));
        if (StringHelper.hasNoText((String)string2)) {
            LOGGER.warn("Error " + iError + " has no text in locale " + locale);
        }
        if (StringHelper.hasText((String)(string = iError.getErrorID()))) {
            string2 = "[" + string + "] " + string2;
        }
        BootstrapInvalidFeedback bootstrapInvalidFeedback = (BootstrapInvalidFeedback)new BootstrapInvalidFeedback().addClass(CSS_CLASS_FORM_GROUP_ERROR_TEXT);
        bootstrapInvalidFeedback.addChild(string2);
        return bootstrapInvalidFeedback;
    }

    @Nullable
    @OverrideOnDemand
    protected IHCElement<?> createSingleErrorNode(@Nonnull IError iError, @Nonnull Locale locale) {
        return DefaultBootstrapFormGroupRenderer.createDefaultErrorNode(iError, locale);
    }

    @OverrideOnDemand
    protected void modifyFinalNode(@Nonnull IBootstrapFormGroupContainer<?> iBootstrapFormGroupContainer, @Nonnull BootstrapFormGroup bootstrapFormGroup, @Nonnull AbstractHCDiv<?> abstractHCDiv) {
    }

    @Nonnull
    public AbstractHCDiv<?> renderFormGroup(@Nonnull IBootstrapFormGroupContainer<?> iBootstrapFormGroupContainer, @Nonnull BootstrapFormGroup bootstrapFormGroup, @Nonnull Locale locale) {
        boolean bl;
        boolean bl2;
        Object object2;
        HCNodeList hCNodeList2;
        EBootstrapFormType eBootstrapFormType = iBootstrapFormGroupContainer.getFormType();
        HCFormLabel hCFormLabel = bootstrapFormGroup.getLabel();
        IHCNode iHCNode = bootstrapFormGroup.getCtrl();
        IHCNode iHCNode2 = bootstrapFormGroup.getHelpText();
        IErrorList iErrorList = bootstrapFormGroup.getErrorList();
        ICommonsList iCommonsList = HCCtrlHelper.getAllHCControls((IHCNode)iHCNode);
        if (iCommonsList != null) {
            BootstrapHelper.markAsFormControls(iCommonsList);
            if (hCFormLabel != null) {
                for (HCNodeList hCNodeList2 : iCommonsList) {
                    hCNodeList2.customAttrs().setAriaLabeledBy((IHCElement)hCFormLabel);
                }
            }
        }
        IHCControl iHCControl = (IHCControl)CollectionHelper.getFirstElement((List)iCommonsList);
        if (iErrorList != null && iHCControl != null && iErrorList.containsAtLeastOneError()) {
            iHCControl.addClass(CBootstrapCSS.IS_INVALID);
        }
        hCNodeList2 = new HCNodeList();
        if (iErrorList != null && iErrorList.isNotEmpty()) {
            for (Object object2 : iErrorList) {
                IHCElement<?> iHCElement = this.createSingleErrorNode((IError)object2, locale);
                if (iHCControl == null) {
                    iHCElement.addClass(CBootstrapCSS.D_BLOCK);
                }
                hCNodeList2.addChild(iHCElement);
            }
        }
        IHCElementWithChildren<?> iHCElementWithChildren = null;
        if (iHCNode2 != null && iHCNode != null) {
            iHCElementWithChildren = this.createHelpTextNode(iHCNode2);
            if (eBootstrapFormType == EBootstrapFormType.INLINE) {
                iHCElementWithChildren.addClass(CBootstrapCSS.SR_ONLY);
            }
        }
        if (this.m_bForceNoCheckBoxHandling || iCommonsList.size() != 1) {
            bl2 = false;
            bl = false;
        } else {
            bl2 = iHCControl instanceof AbstractHCCheckBox;
            bl = iHCControl instanceof AbstractHCRadioButton;
        }
        if (bl2 || bl) {
            HCDiv hCDiv = new HCDiv();
            hCDiv.addClass(CBootstrapCSS.FORM_CHECK);
            iHCControl.addClass(CBootstrapCSS.FORM_CHECK_INPUT);
            hCDiv.addChild(iHCNode);
            if (hCFormLabel != null) {
                hCFormLabel.addClass(CBootstrapCSS.FORM_CHECK_LABEL);
                hCDiv.addChild((IHCNode)hCFormLabel);
                hCFormLabel.setFor((IHCHasID)iHCControl);
                this.modifyFirstControlIfLabelIsPresent((IHCElementWithChildren<?>)hCFormLabel, (IHCControl<?>)iHCControl);
            }
            ((HCDiv)hCDiv.addChild((IHCNode)hCNodeList2)).addChild(iHCElementWithChildren);
            object2 = hCDiv;
        } else {
            object2 = new BootstrapRow();
            object2.addClass(CBootstrapCSS.FORM_GROUP);
            if (hCFormLabel == null || hCFormLabel.hasNoChildren()) {
                if (iHCNode instanceof IHCElement) {
                    iBootstrapFormGroupContainer.getLeft().applyOffsetTo((IHCElement)iHCNode);
                }
                ((AbstractHCDiv)((AbstractHCDiv)object2.addChild(iHCNode)).addChild((IHCNode)hCNodeList2)).addChild(iHCElementWithChildren);
            } else {
                if (eBootstrapFormType == EBootstrapFormType.INLINE) {
                    hCFormLabel.addClass(CBootstrapCSS.SR_ONLY);
                }
                if (iHCControl != null) {
                    hCFormLabel.setFor((IHCHasID)iHCControl);
                    this.modifyFirstControlIfLabelIsPresent((IHCElementWithChildren<?>)hCFormLabel, (IHCControl<?>)iHCControl);
                }
                iBootstrapFormGroupContainer.getLeft().applyTo((IHCElement<?>)hCFormLabel);
                HCDiv hCDiv = (HCDiv)((HCDiv)((HCDiv)new HCDiv().addChild(iHCNode)).addChild((IHCNode)hCNodeList2)).addChild(iHCElementWithChildren);
                iBootstrapFormGroupContainer.getRight().applyTo((IHCElement<?>)hCDiv);
                object2.addChildren(new IHCNode[]{hCFormLabel, hCDiv});
            }
        }
        bootstrapFormGroup.applyBasicHTMLTo((IHCElement<?>)object2);
        this.modifyFinalNode(iBootstrapFormGroupContainer, bootstrapFormGroup, (AbstractHCDiv<?>)object2);
        return object2;
    }
}

