/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.inputgroup;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.AbstractHCDiv;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.textlevel.HCSpan;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.button.BootstrapButton;
import com.helger.photon.bootstrap4.inputgroup.EBootstrapInputGroupSize;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BootstrapInputGroup
extends AbstractHCDiv<BootstrapInputGroup> {
    private final EBootstrapInputGroupSize m_eSize;
    private final HCNodeList m_aPrefixes = new HCNodeList();
    private final IHCNode m_aInput;
    private final HCNodeList m_aSuffixes = new HCNodeList();

    public BootstrapInputGroup(@Nonnull IHCNode iHCNode) {
        this(EBootstrapInputGroupSize.DEFAULT, iHCNode);
    }

    public BootstrapInputGroup(@Nonnull EBootstrapInputGroupSize eBootstrapInputGroupSize, @Nonnull IHCNode iHCNode) {
        this.m_eSize = (EBootstrapInputGroupSize)((Object)ValueEnforcer.notNull((Object)((Object)eBootstrapInputGroupSize), (String)"Size"));
        this.m_aInput = (IHCNode)ValueEnforcer.notNull((Object)iHCNode, (String)"Input");
    }

    @Nonnull
    public final EBootstrapInputGroupSize getSize() {
        return this.m_eSize;
    }

    @Nonnull
    @ReturnsMutableObject
    public final HCNodeList prefixes() {
        return this.m_aPrefixes;
    }

    @Nonnull
    public BootstrapInputGroup setPrefix(@Nullable String string) {
        this.m_aPrefixes.setChild(string);
        return this;
    }

    @Nonnull
    public BootstrapInputGroup setPrefix(@Nullable IHCNode iHCNode) {
        this.m_aPrefixes.setChild(iHCNode);
        return this;
    }

    @Nonnull
    public final IHCNode getInput() {
        return this.m_aInput;
    }

    @Nonnull
    @ReturnsMutableObject
    public final HCNodeList suffixes() {
        return this.m_aSuffixes;
    }

    @Nonnull
    public BootstrapInputGroup setSuffix(@Nullable String string) {
        this.m_aSuffixes.setChild(string);
        return this;
    }

    @Nonnull
    public BootstrapInputGroup setSuffix(@Nullable IHCNode iHCNode) {
        this.m_aSuffixes.setChild(iHCNode);
        return this;
    }

    public boolean hasNeitherPrefixNorSuffix() {
        return this.m_aPrefixes.hasNoChildren() && this.m_aSuffixes.hasNoChildren();
    }

    @Nonnull
    @OverrideOnDemand
    protected HCDiv createPrependGroup() {
        return (HCDiv)new HCDiv().addClass(CBootstrapCSS.INPUT_GROUP_PREPEND);
    }

    @Nonnull
    @OverrideOnDemand
    protected HCDiv createAppendGroup() {
        return (HCDiv)new HCDiv().addClass(CBootstrapCSS.INPUT_GROUP_APPEND);
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        HCDiv hCDiv;
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClasses(new ICSSClassProvider[]{CBootstrapCSS.INPUT_GROUP, this.m_eSize});
        if (this.m_aPrefixes.hasChildren()) {
            hCDiv = (HCDiv)this.addAndReturnChild((IHCNode)this.createPrependGroup());
            for (IHCNode iHCNode : this.m_aPrefixes.getChildren()) {
                if (iHCNode instanceof BootstrapButton) {
                    hCDiv.addChild(iHCNode);
                    continue;
                }
                hCDiv.addChild((IHCNode)((HCSpan)new HCSpan().addClass(CBootstrapCSS.INPUT_GROUP_TEXT)).addChild(iHCNode));
            }
        }
        this.addChild(this.m_aInput);
        if (this.m_aSuffixes.hasChildren()) {
            hCDiv = (HCDiv)this.addAndReturnChild((IHCNode)this.createAppendGroup());
            for (IHCNode iHCNode : this.m_aSuffixes.getChildren()) {
                if (iHCNode instanceof BootstrapButton) {
                    hCDiv.addChild(iHCNode);
                    continue;
                }
                hCDiv.addChild((IHCNode)((HCSpan)new HCSpan().addClass(CBootstrapCSS.INPUT_GROUP_TEXT)).addChild(iHCNode));
            }
        }
    }
}

