/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.html.IHCHasCSSClasses;
import com.helger.photon.bootstrap4.utils.EBootstrapBorderColorType;
import com.helger.photon.bootstrap4.utils.EBootstrapBorderRadiusType;
import com.helger.photon.bootstrap4.utils.EBootstrapBorderType;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BootstrapBorderBuilder
implements Serializable {
    private EBootstrapBorderType m_eType = EBootstrapBorderType.NONE;
    private EBootstrapBorderColorType m_eColor = null;
    private EBootstrapBorderRadiusType m_eRadius = EBootstrapBorderRadiusType.NOT_ROUNDED;

    @Nonnull
    public BootstrapBorderBuilder type(@Nonnull EBootstrapBorderType eBootstrapBorderType) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapBorderType), (String)"Type");
        this.m_eType = eBootstrapBorderType;
        return this;
    }

    @Nonnull
    public BootstrapBorderBuilder color(@Nullable EBootstrapBorderColorType eBootstrapBorderColorType) {
        this.m_eColor = eBootstrapBorderColorType;
        return this;
    }

    @Nonnull
    public BootstrapBorderBuilder radius(@Nonnull EBootstrapBorderRadiusType eBootstrapBorderRadiusType) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapBorderRadiusType), (String)"Radius");
        this.m_eRadius = eBootstrapBorderRadiusType;
        return this;
    }

    public void applyTo(@Nonnull IHCHasCSSClasses<?> iHCHasCSSClasses) {
        iHCHasCSSClasses.addClasses(new ICSSClassProvider[]{this.m_eType, this.m_eColor, this.m_eRadius});
    }
}

