/*
 * Decompiled with CFR 0.152.
 */
package com.helger.poi;

import com.helger.commons.system.SystemProperties;
import com.helger.poi.POISLF4JLogger;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class POISetup {
    public static final String SYS_PROP_POI_LOGGER = "org.apache.poi.util.POILogger";
    private static final AtomicBoolean s_aInited = new AtomicBoolean(false);

    private POISetup() {
    }

    public static void enableCustomLogger(boolean bl) {
        if (bl) {
            SystemProperties.setPropertyValue((String)SYS_PROP_POI_LOGGER, (String)POISLF4JLogger.class.getName());
        } else {
            SystemProperties.removePropertyValue((String)SYS_PROP_POI_LOGGER);
        }
    }

    public static boolean isInited() {
        return s_aInited.get();
    }

    public static void initOnDemand() {
        if (s_aInited.compareAndSet(false, true)) {
            POISetup.enableCustomLogger(true);
        }
    }

    static {
        SystemProperties.setPropertyValue((String)"HSSFWorkbook.SheetInitialCapacity", (int)1);
        SystemProperties.setPropertyValue((String)"HSSFSheet.RowInitialCapacity", (int)20);
        SystemProperties.setPropertyValue((String)"HSSFRow.ColInitialCapacity", (int)5);
    }
}

