/*
 * Decompiled with CFR 0.152.
 */
package com.helger.poi.excel;

import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.NotOLE2FileException;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class ExcelReadHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelReadHelper.class);

    private ExcelReadHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Workbook readWorkbookFromInputStream(@Nonnull IHasInputStream iHasInputStream) {
        InputStream inputStream = null;
        try {
            inputStream = iHasInputStream.getInputStream();
            if (inputStream == null) {
                Workbook workbook = null;
                return workbook;
            }
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(inputStream);
            return hSSFWorkbook;
        }
        catch (OfficeXmlFileException officeXmlFileException) {
            StreamHelper.close((AutoCloseable)inputStream);
            try {
                inputStream = iHasInputStream.getInputStream();
                XSSFWorkbook xSSFWorkbook = new XSSFWorkbook(inputStream);
                return xSSFWorkbook;
            }
            catch (IOException iOException) {
                LOGGER.error("Error trying to read XLSX file from " + iHasInputStream, (Throwable)officeXmlFileException);
            }
        }
        catch (NotOLE2FileException notOLE2FileException) {
            LOGGER.error("Error trying to read non-Excel file from " + iHasInputStream + ": " + notOLE2FileException.getMessage());
        }
        catch (IOException iOException) {
            LOGGER.error("Error trying to read XLS file from " + iHasInputStream, (Throwable)iOException);
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
        return null;
    }

    @Nonnull
    private static Number _getAsNumberObject(double d) {
        if (d == (double)((int)d)) {
            return (int)d;
        }
        if (d == (double)((long)d)) {
            return (long)d;
        }
        return d;
    }

    @Nullable
    public static Object getCellValueObject(@Nullable Cell cell) {
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case NUMERIC: {
                return ExcelReadHelper._getAsNumberObject(cell.getNumericCellValue());
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case FORMULA: {
                CellType cellType2 = cell.getCachedFormulaResultType();
                switch (cellType2) {
                    case NUMERIC: {
                        return ExcelReadHelper._getAsNumberObject(cell.getNumericCellValue());
                    }
                    case STRING: {
                        return cell.getStringCellValue();
                    }
                    case BOOLEAN: {
                        return cell.getBooleanCellValue();
                    }
                }
                throw new IllegalArgumentException("The cell formula type " + cellType2 + " is unsupported!");
            }
            case BLANK: {
                return null;
            }
        }
        throw new IllegalArgumentException("The cell type " + cellType + " is unsupported!");
    }

    @Nullable
    public static String getCellValueString(@Nullable Cell cell) {
        Object object = ExcelReadHelper.getCellValueObject(cell);
        return object == null ? null : object.toString();
    }

    @Nullable
    public static String getCellValueNormalizedString(@Nullable Cell cell) {
        String string = ExcelReadHelper.getCellValueString(cell);
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        for (char c : cArray) {
            if (Character.getType(c) == 15) continue;
            stringBuilder.append(c);
        }
        return StringHelper.replaceAllRepeatedly((String)stringBuilder.toString().trim(), (String)"  ", (String)" ");
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static Boolean getCellValueBoolean(@Nullable Cell cell) {
        Object object = ExcelReadHelper.getCellValueObject(cell);
        if (object != null && !(object instanceof Boolean)) {
            LOGGER.warn("Failed to get cell value as boolean: " + object.getClass());
            return null;
        }
        return (Boolean)object;
    }

    @Nullable
    public static Number getCellValueNumber(@Nullable Cell cell) {
        Object object = ExcelReadHelper.getCellValueObject(cell);
        if (object != null && !(object instanceof Number)) {
            LOGGER.warn("Failed to get cell value as number: " + object.getClass());
            return null;
        }
        return (Number)object;
    }

    @Nullable
    public static Date getCellValueJavaDate(@Nullable Cell cell) {
        if (cell != null) {
            try {
                return cell.getDateCellValue();
            }
            catch (RuntimeException runtimeException) {
                LOGGER.warn("Failed to get cell value as date: " + runtimeException.getMessage());
            }
        }
        return null;
    }

    @Nullable
    public static LocalDateTime getCellValueLocalDateTime(@Nullable Cell cell) {
        Date date = ExcelReadHelper.getCellValueJavaDate(cell);
        return date == null ? null : PDTFactory.createLocalDateTime((Date)date);
    }

    @Nullable
    public static LocalDate getCellValueLocalDate(@Nullable Cell cell) {
        Date date = ExcelReadHelper.getCellValueJavaDate(cell);
        return date == null ? null : PDTFactory.createLocalDate((Date)date);
    }

    @Nullable
    public static LocalTime getCellValueLocalTime(@Nullable Cell cell) {
        Date date = ExcelReadHelper.getCellValueJavaDate(cell);
        return date == null ? null : PDTFactory.createLocalTime((Date)date);
    }

    @Nullable
    public static RichTextString getCellValueRichText(@Nullable Cell cell) {
        return cell == null ? null : cell.getRichStringCellValue();
    }

    @Nullable
    public static String getCellFormula(@Nullable Cell cell) {
        if (cell != null) {
            try {
                return cell.getCellFormula();
            }
            catch (RuntimeException runtimeException) {
                LOGGER.warn("Failed to get cell formula: " + runtimeException.getMessage());
            }
        }
        return null;
    }

    @Nullable
    public static Hyperlink getHyperlink(@Nullable Cell cell) {
        return cell == null ? null : cell.getHyperlink();
    }

    public static boolean canBeReadAsNumericCell(@Nullable Cell cell) {
        if (cell == null) {
            return false;
        }
        CellType cellType = cell.getCellType();
        return cellType == CellType.BLANK || cellType == CellType.NUMERIC || cellType == CellType.FORMULA;
    }
}

