/*
 * Decompiled with CFR 0.152.
 */
package com.helger.poi.excel.style;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

@NotThreadSafe
public class ExcelStyle
implements ICloneable<ExcelStyle>,
Serializable {
    public static final boolean DEFAULT_WRAP_TEXT = false;
    private HorizontalAlignment m_eAlign;
    private VerticalAlignment m_eVAlign;
    private boolean m_bWrapText = false;
    private String m_sDataFormat;
    private IndexedColors m_eFillBackgroundColor;
    private IndexedColors m_eFillForegroundColor;
    private FillPatternType m_eFillPattern;
    private BorderStyle m_eBorderTop;
    private BorderStyle m_eBorderRight;
    private BorderStyle m_eBorderBottom;
    private BorderStyle m_eBorderLeft;
    private int m_nFontIndex = -1;

    public ExcelStyle() {
    }

    public ExcelStyle(@Nonnull ExcelStyle excelStyle) {
        ValueEnforcer.notNull((Object)excelStyle, (String)"Other");
        this.m_eAlign = excelStyle.m_eAlign;
        this.m_eVAlign = excelStyle.m_eVAlign;
        this.m_bWrapText = excelStyle.m_bWrapText;
        this.m_sDataFormat = excelStyle.m_sDataFormat;
        this.m_eFillBackgroundColor = excelStyle.m_eFillBackgroundColor;
        this.m_eFillForegroundColor = excelStyle.m_eFillForegroundColor;
        this.m_eFillPattern = excelStyle.m_eFillPattern;
        this.m_eBorderTop = excelStyle.m_eBorderTop;
        this.m_eBorderRight = excelStyle.m_eBorderRight;
        this.m_eBorderBottom = excelStyle.m_eBorderBottom;
        this.m_eBorderLeft = excelStyle.m_eBorderLeft;
        this.m_nFontIndex = excelStyle.m_nFontIndex;
    }

    @Nullable
    public HorizontalAlignment getAlign() {
        return this.m_eAlign;
    }

    @Nonnull
    public ExcelStyle setAlign(@Nullable HorizontalAlignment horizontalAlignment) {
        this.m_eAlign = horizontalAlignment;
        return this;
    }

    @Nullable
    public VerticalAlignment getVerticalAlign() {
        return this.m_eVAlign;
    }

    @Nonnull
    public ExcelStyle setVerticalAlign(@Nullable VerticalAlignment verticalAlignment) {
        this.m_eVAlign = verticalAlignment;
        return this;
    }

    public boolean isWrapText() {
        return this.m_bWrapText;
    }

    @Nonnull
    public ExcelStyle setWrapText(boolean bl) {
        this.m_bWrapText = bl;
        return this;
    }

    @Nullable
    public String getDataFormat() {
        return this.m_sDataFormat;
    }

    @Nonnull
    public ExcelStyle setDataFormat(@Nullable String string) {
        this.m_sDataFormat = string;
        return this;
    }

    @Nullable
    public IndexedColors getFillBackgroundColor() {
        return this.m_eFillBackgroundColor;
    }

    @Nonnull
    public ExcelStyle setFillBackgroundColor(@Nullable IndexedColors indexedColors) {
        this.m_eFillBackgroundColor = indexedColors;
        return this;
    }

    @Nullable
    public IndexedColors getFillForegroundColor() {
        return this.m_eFillForegroundColor;
    }

    @Nonnull
    public ExcelStyle setFillForegroundColor(@Nullable IndexedColors indexedColors) {
        this.m_eFillForegroundColor = indexedColors;
        return this;
    }

    @Nullable
    public FillPatternType getFillPattern() {
        return this.m_eFillPattern;
    }

    @Nonnull
    public ExcelStyle setFillPattern(@Nullable FillPatternType fillPatternType) {
        this.m_eFillPattern = fillPatternType;
        return this;
    }

    @Nullable
    public BorderStyle getBorderTop() {
        return this.m_eBorderTop;
    }

    @Nonnull
    public ExcelStyle setBorderTop(@Nullable BorderStyle borderStyle) {
        this.m_eBorderTop = borderStyle;
        return this;
    }

    @Nullable
    public BorderStyle getBorderRight() {
        return this.m_eBorderRight;
    }

    @Nonnull
    public ExcelStyle setBorderRight(@Nullable BorderStyle borderStyle) {
        this.m_eBorderRight = borderStyle;
        return this;
    }

    @Nullable
    public BorderStyle getBorderBottom() {
        return this.m_eBorderBottom;
    }

    @Nonnull
    public ExcelStyle setBorderBottom(@Nullable BorderStyle borderStyle) {
        this.m_eBorderBottom = borderStyle;
        return this;
    }

    @Nullable
    public BorderStyle getBorderLeft() {
        return this.m_eBorderLeft;
    }

    @Nonnull
    public ExcelStyle setBorderLeft(@Nullable BorderStyle borderStyle) {
        this.m_eBorderLeft = borderStyle;
        return this;
    }

    @Nonnull
    public ExcelStyle setBorder(@Nullable BorderStyle borderStyle) {
        return this.setBorderTop(borderStyle).setBorderRight(borderStyle).setBorderBottom(borderStyle).setBorderLeft(borderStyle);
    }

    public int getFontIndex() {
        return this.m_nFontIndex;
    }

    @Nonnull
    public ExcelStyle setFontIndex(int n) {
        this.m_nFontIndex = n;
        return this;
    }

    @Nonnull
    public ExcelStyle setFont(@Nonnull Font font) {
        ValueEnforcer.notNull((Object)font, (String)"Font");
        return this.setFontIndex(font.getIndexAsInt());
    }

    @Nonnull
    public ExcelStyle getClone() {
        return new ExcelStyle(this);
    }

    public void fillCellStyle(@Nonnull Workbook workbook, @Nonnull CellStyle cellStyle, @Nonnull CreationHelper creationHelper) {
        if (this.m_eAlign != null) {
            cellStyle.setAlignment(this.m_eAlign);
        }
        if (this.m_eVAlign != null) {
            cellStyle.setVerticalAlignment(this.m_eVAlign);
        }
        cellStyle.setWrapText(this.m_bWrapText);
        if (this.m_sDataFormat != null) {
            cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(this.m_sDataFormat));
        }
        if (this.m_eFillBackgroundColor != null) {
            cellStyle.setFillBackgroundColor(this.m_eFillBackgroundColor.getIndex());
        }
        if (this.m_eFillForegroundColor != null) {
            cellStyle.setFillForegroundColor(this.m_eFillForegroundColor.getIndex());
        }
        if (this.m_eFillPattern != null) {
            cellStyle.setFillPattern(this.m_eFillPattern);
        }
        if (this.m_eBorderTop != null) {
            cellStyle.setBorderTop(this.m_eBorderTop);
        }
        if (this.m_eBorderRight != null) {
            cellStyle.setBorderRight(this.m_eBorderRight);
        }
        if (this.m_eBorderBottom != null) {
            cellStyle.setBorderBottom(this.m_eBorderBottom);
        }
        if (this.m_eBorderLeft != null) {
            cellStyle.setBorderLeft(this.m_eBorderLeft);
        }
        if (this.m_nFontIndex >= 0) {
            cellStyle.setFont(workbook.getFontAt(this.m_nFontIndex));
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ExcelStyle excelStyle = (ExcelStyle)object;
        return EqualsHelper.equals((Object)this.m_eAlign, (Object)excelStyle.m_eAlign) && EqualsHelper.equals((Object)this.m_eVAlign, (Object)excelStyle.m_eVAlign) && this.m_bWrapText == excelStyle.m_bWrapText && EqualsHelper.equals((Object)this.m_sDataFormat, (Object)excelStyle.m_sDataFormat) && EqualsHelper.equals((Object)this.m_eFillBackgroundColor, (Object)excelStyle.m_eFillBackgroundColor) && EqualsHelper.equals((Object)this.m_eFillForegroundColor, (Object)excelStyle.m_eFillForegroundColor) && EqualsHelper.equals((Object)this.m_eFillPattern, (Object)excelStyle.m_eFillPattern) && EqualsHelper.equals((Object)this.m_eBorderTop, (Object)excelStyle.m_eBorderTop) && EqualsHelper.equals((Object)this.m_eBorderRight, (Object)excelStyle.m_eBorderRight) && EqualsHelper.equals((Object)this.m_eBorderBottom, (Object)excelStyle.m_eBorderBottom) && EqualsHelper.equals((Object)this.m_eBorderLeft, (Object)excelStyle.m_eBorderLeft) && this.m_nFontIndex == excelStyle.m_nFontIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eAlign).append((Enum)this.m_eVAlign).append(this.m_bWrapText).append((Object)this.m_sDataFormat).append((Enum)this.m_eFillBackgroundColor).append((Enum)this.m_eFillForegroundColor).append((Enum)this.m_eFillPattern).append((Enum)this.m_eBorderTop).append((Enum)this.m_eBorderRight).append((Enum)this.m_eBorderBottom).append((Enum)this.m_eBorderLeft).append(this.m_nFontIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("align", (Object)this.m_eAlign).appendIfNotNull("verticalAlign", (Object)this.m_eVAlign).append("wrapText", this.m_bWrapText).appendIfNotNull("dataFormat", (Object)this.m_sDataFormat).appendIfNotNull("fillBackgroundColor", (Object)this.m_eFillBackgroundColor).appendIfNotNull("fillForegroundColor", (Object)this.m_eFillForegroundColor).appendIfNotNull("fillPattern", (Object)this.m_eFillPattern).appendIfNotNull("borderTop", (Object)this.m_eBorderTop).appendIfNotNull("borderRight", (Object)this.m_eBorderRight).appendIfNotNull("borderBottom", (Object)this.m_eBorderBottom).appendIfNotNull("borderLeft", (Object)this.m_eBorderLeft).append("fontIndex", this.m_nFontIndex).getToString();
    }
}

