/*
 * Decompiled with CFR 0.152.
 */
package com.helger.poi.excel;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.poi.POISetup;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public enum EExcelVersion implements IHasID<String>
{
    XLS("xls"){

        @Nonnull
        public HSSFWorkbook createWorkbook() {
            return new HSSFWorkbook();
        }

        @Nullable
        public HSSFWorkbook readWorkbook(@Nonnull @WillClose InputStream inputStream) {
            try {
                return new HSSFWorkbook(inputStream);
            }
            catch (IOException | OfficeXmlFileException throwable) {
                return null;
            }
        }

        @Nonnull
        public HSSFRichTextString createRichText(String string) {
            return new HSSFRichTextString(string);
        }

        @Override
        @Nonnull
        public String getFileExtension() {
            return ".xls";
        }

        @Override
        @Nonnull
        public IMimeType getMimeType() {
            return CMimeType.APPLICATION_MS_EXCEL;
        }

        @Override
        public int getRowLimitPerSheet() {
            return 65536;
        }
    }
    ,
    XLSX("xlsx"){

        @Nonnull
        public XSSFWorkbook createWorkbook() {
            return new XSSFWorkbook();
        }

        @Nullable
        public XSSFWorkbook readWorkbook(@Nonnull @WillClose InputStream inputStream) {
            try {
                return new XSSFWorkbook(inputStream);
            }
            catch (IOException | NotOfficeXmlFileException throwable) {
                return null;
            }
        }

        @Nonnull
        public XSSFRichTextString createRichText(String string) {
            return new XSSFRichTextString(string);
        }

        @Override
        @Nonnull
        public String getFileExtension() {
            return ".xlsx";
        }

        @Override
        @Nonnull
        public IMimeType getMimeType() {
            return CMimeType.APPLICATION_MS_EXCEL_2007;
        }

        @Override
        public int getRowLimitPerSheet() {
            return -1;
        }
    };

    private final String m_sID;

    private EExcelVersion(String string2) {
        this.m_sID = string2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public abstract Workbook createWorkbook();

    @Nullable
    public abstract Workbook readWorkbook(@Nonnull InputStream var1);

    @Nonnull
    public abstract RichTextString createRichText(String var1);

    @Nonnull
    public abstract String getFileExtension();

    @Nonnull
    public abstract IMimeType getMimeType();

    public boolean hasRowLimitPerSheet() {
        return this.getRowLimitPerSheet() > 0;
    }

    @CheckForSigned
    public abstract int getRowLimitPerSheet();

    @Nullable
    public static EExcelVersion getFromIDOrNull(@Nullable String string) {
        return (EExcelVersion)EnumHelper.getFromIDOrNull(EExcelVersion.class, (Object)string);
    }

    @Nullable
    public static EExcelVersion getFromIDOrDefault(@Nullable String string, @Nullable EExcelVersion eExcelVersion) {
        return (EExcelVersion)EnumHelper.getFromIDOrDefault(EExcelVersion.class, (Object)string, (Enum)eExcelVersion);
    }

    static {
        POISetup.initOnDemand();
    }
}

