/*
 * Decompiled with CFR 0.152.
 */
package com.helger.poi.excel;

import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.IStabilityClassifier;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelFormulaEvaluator {
    private final FormulaEvaluator m_aEvaluator;

    public ExcelFormulaEvaluator(@Nonnull Workbook workbook) {
        this.m_aEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
    }

    public ExcelFormulaEvaluator(@Nonnull Workbook workbook, @Nullable IStabilityClassifier iStabilityClassifier) {
        this.m_aEvaluator = workbook instanceof HSSFWorkbook ? new HSSFFormulaEvaluator((HSSFWorkbook)workbook, iStabilityClassifier) : XSSFFormulaEvaluator.create((XSSFWorkbook)((XSSFWorkbook)workbook), (IStabilityClassifier)iStabilityClassifier, null);
    }

    public CellValue evaluate(@Nonnull Cell cell) {
        return this.m_aEvaluator.evaluate(cell);
    }

    @Nullable
    public CellType evaluateFormulaCell(@Nonnull Cell cell) {
        return this.m_aEvaluator.evaluateFormulaCell(cell);
    }

    @Nonnull
    public Cell evaluateInCell(@Nonnull Cell cell) {
        return this.m_aEvaluator.evaluateInCell(cell);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("evaluator", (Object)this.m_aEvaluator).getToString();
    }
}

