/*
 * Decompiled with CFR 0.152.
 */
package com.helger.poi.excel;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.resource.IWritableResource;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.poi.excel.CExcel;
import com.helger.poi.excel.EExcelVersion;
import com.helger.poi.excel.style.ExcelStyle;
import com.helger.poi.excel.style.ExcelStyleCache;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkbookCreationHelper
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbookCreationHelper.class);
    private final Workbook m_aWB;
    private final CreationHelper m_aCreationHelper;
    private final ExcelStyleCache m_aStyleCache = new ExcelStyleCache();
    private Sheet m_aLastSheet;
    private int m_nLastSheetRowIndex = 0;
    private Row m_aLastRow;
    private int m_nLastRowCellIndex = 0;
    private Cell m_aLastCell;
    private int m_nMaxCellIndex = 0;
    private int m_nCreatedCellStyles = 0;

    public WorkbookCreationHelper(@Nonnull EExcelVersion eExcelVersion) {
        this(eExcelVersion.createWorkbook());
    }

    public WorkbookCreationHelper(@Nonnull Workbook workbook) {
        this.m_aWB = (Workbook)ValueEnforcer.notNull((Object)workbook, (String)"Workbook");
        this.m_aCreationHelper = workbook.getCreationHelper();
    }

    @Override
    public void close() {
        try {
            this.m_aWB.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Nonnull
    public Workbook getWorkbook() {
        return this.m_aWB;
    }

    @Nonnull
    public Font createFont() {
        return this.m_aWB.createFont();
    }

    @Nonnull
    public Sheet createNewSheet() {
        return this.createNewSheet(null);
    }

    @Nonnull
    public Sheet createNewSheet(@Nullable String string) {
        this.m_aLastSheet = string == null ? this.m_aWB.createSheet() : this.m_aWB.createSheet(WorkbookUtil.createSafeSheetName((String)string));
        this.m_nLastSheetRowIndex = 0;
        this.m_aLastRow = null;
        this.m_nLastRowCellIndex = 0;
        this.m_aLastCell = null;
        this.m_nMaxCellIndex = 0;
        return this.m_aLastSheet;
    }

    @Nonnull
    public Row addRow() {
        if (this.m_aLastSheet == null) {
            throw new IllegalStateException("A sheet needs to be created before a row can be added! Call createNewSheet");
        }
        this.m_aLastRow = this.m_aLastSheet.createRow(this.m_nLastSheetRowIndex++);
        this.m_nLastRowCellIndex = 0;
        this.m_aLastCell = null;
        return this.m_aLastRow;
    }

    @Nonnegative
    protected int getRowIndex() {
        return this.m_nLastSheetRowIndex - 1;
    }

    @Nonnegative
    public int getRowCount() {
        return this.m_nLastSheetRowIndex;
    }

    @Nonnull
    public Cell addCell() {
        if (this.m_aLastRow == null) {
            throw new IllegalStateException("A row needs to be created before a cell can be added! Call addRow");
        }
        this.m_aLastCell = this.m_aLastRow.createCell(this.m_nLastRowCellIndex++);
        this.m_aLastCell.setBlank();
        if (this.m_nLastRowCellIndex > this.m_nMaxCellIndex) {
            this.m_nMaxCellIndex = this.m_nLastRowCellIndex;
        }
        return this.m_aLastCell;
    }

    @Nonnull
    public Cell addCell(boolean bl) {
        Cell cell = this.addCell();
        cell.setCellValue(bl);
        return cell;
    }

    @Nonnull
    public Cell addCell(@Nullable Calendar calendar) {
        Cell cell = this.addCell();
        if (calendar != null) {
            cell.setCellValue(calendar);
        }
        return cell;
    }

    @Nonnull
    public Cell addCell(@Nullable Date date) {
        Cell cell = this.addCell();
        if (date != null) {
            cell.setCellValue(date);
        }
        return cell;
    }

    @Nonnull
    public Cell addCell(@Nullable LocalDate localDate) {
        if (localDate == null) {
            return this.addCell();
        }
        return this.addCell(PDTFactory.createZonedDateTime((LocalDate)localDate));
    }

    @Nonnull
    public Cell addCell(@Nullable LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return this.addCell();
        }
        return this.addCell(PDTFactory.createZonedDateTime((LocalDateTime)localDateTime));
    }

    @Nonnull
    public Cell addCell(@Nullable ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return this.addCell();
        }
        return this.addCell(GregorianCalendar.from(zonedDateTime));
    }

    @Nonnull
    public Cell addCell(@Nullable BigInteger bigInteger) {
        if (bigInteger == null) {
            return this.addCell();
        }
        if (CExcel.canBeNumericValue(bigInteger)) {
            return this.addCell(bigInteger.longValue());
        }
        return this.addCell(bigInteger.toString());
    }

    @Nonnull
    public Cell addCell(double d) {
        Cell cell = this.addCell();
        cell.setCellValue(d);
        return cell;
    }

    @Nonnull
    public Cell addCell(@Nullable BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.addCell();
        }
        try {
            return this.addCell(bigDecimal.doubleValue());
        }
        catch (NumberFormatException numberFormatException) {
            return this.addCell(bigDecimal.toString());
        }
    }

    @Nonnull
    public Cell addCell(@Nullable RichTextString richTextString) {
        Cell cell = this.addCell();
        if (richTextString != null) {
            cell.setCellValue(richTextString);
        }
        return cell;
    }

    @Nonnull
    public Cell addCell(@Nullable String string) {
        Cell cell = this.addCell();
        if (string != null) {
            cell.setCellValue(string);
        }
        return cell;
    }

    @Nonnull
    public Cell addCellFormula(@Nullable String string) {
        Cell cell = this.addCell();
        cell.setCellFormula(string);
        return cell;
    }

    public int addMergeRegionInCurrentRow(@Nonnegative int n, @Nonnegative int n2) {
        int n3 = this.getRowIndex();
        return this.addMergeRegion(n3, n3, n, n2);
    }

    public int addMergeRegion(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4) {
        return this.m_aLastSheet.addMergedRegion(new CellRangeAddress(n, n2, n3, n4));
    }

    public void addCellStyle(@Nonnull ExcelStyle excelStyle) {
        ValueEnforcer.notNull((Object)excelStyle, (String)"ExcelStyle");
        if (this.m_aLastCell == null) {
            throw new IllegalStateException("No cell present for current row!");
        }
        CellStyle cellStyle = this.m_aStyleCache.getCellStyle(excelStyle);
        if (cellStyle == null) {
            cellStyle = this.m_aWB.createCellStyle();
            excelStyle.fillCellStyle(this.m_aWB, cellStyle, this.m_aCreationHelper);
            this.m_aStyleCache.addCellStyle(excelStyle, cellStyle);
            ++this.m_nCreatedCellStyles;
        }
        this.m_aLastCell.setCellStyle(cellStyle);
    }

    @Nonnegative
    public int getCreatedCellStyleCount() {
        return this.m_nCreatedCellStyles;
    }

    @Nonnegative
    public int getCellCountInRow() {
        return this.m_nLastRowCellIndex;
    }

    @Nonnegative
    public int getMaximumCellCountInRowInSheet() {
        return this.m_nMaxCellIndex;
    }

    public void autoSizeAllColumns() {
        for (int n = 0; n < this.m_nMaxCellIndex; n = (int)((short)(n + 1))) {
            try {
                this.m_aLastSheet.autoSizeColumn(n);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warn("Failed to resize column " + n + ": column too wide!");
            }
        }
    }

    public void autoFilterAllColumns() {
        this.autoFilterAllColumns(0);
    }

    public void autoFilterAllColumns(@Nonnegative int n) {
        this.m_aLastSheet.setAutoFilter(new CellRangeAddress(n, n, 0, this.m_nMaxCellIndex - 1));
    }

    @Nonnull
    public ESuccess writeTo(@Nonnull File file) {
        return this.writeTo(FileHelper.getOutputStream((File)file));
    }

    @Nonnull
    public ESuccess writeTo(@Nonnull IWritableResource iWritableResource) {
        return this.writeTo(iWritableResource.getOutputStream(EAppend.TRUNCATE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ESuccess writeTo(@Nonnull @WillClose OutputStream outputStream) {
        try {
            ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
            if (this.m_nCreatedCellStyles > 0 && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Writing Excel workbook with " + this.m_nCreatedCellStyles + " different cell styles");
            }
            this.m_aWB.write(outputStream);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (IOException iOException) {
            if (!StreamHelper.isKnownEOFException((Throwable)iOException)) {
                LOGGER.error("Failed to write Excel workbook to output stream " + outputStream, (Throwable)iOException);
            }
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    @Nullable
    public byte[] getAsByteArray() {
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            if (this.writeTo((OutputStream)nonBlockingByteArrayOutputStream).isFailure()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = nonBlockingByteArrayOutputStream.getBufferOrCopy();
            return byArray;
        }
    }
}

