/*
 * Decompiled with CFR 0.152.
 */
package com.helger.poi.excel.style;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.poi.excel.style.ExcelStyle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.ss.usermodel.CellStyle;

public class ExcelStyleCache {
    private final ICommonsMap<ExcelStyle, CellStyle> m_aMap = new CommonsHashMap();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsMap<ExcelStyle, CellStyle> map() {
        return this.m_aMap;
    }

    @Nullable
    public CellStyle getCellStyle(@Nullable ExcelStyle excelStyle) {
        return (CellStyle)this.m_aMap.get((Object)excelStyle);
    }

    public void addCellStyle(@Nonnull ExcelStyle excelStyle, @Nonnull CellStyle cellStyle) {
        ValueEnforcer.notNull((Object)excelStyle, (String)"ExcelStyle");
        ValueEnforcer.notNull((Object)cellStyle, (String)"CellStyle");
        this.m_aMap.put((Object)excelStyle, (Object)cellStyle);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Map", this.m_aMap).getToString();
    }
}

