/**
 * Copyright (C) 2006-2014 phloc systems (www.phloc.com)
 * Copyright (C) 2014 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.schedule.longrun;

import javax.annotation.Nonnull;

import org.quartz.Job;

import com.helger.commons.text.ISimpleMultiLingualText;

/**
 * This is a marker interface that identifies long running background jobs.
 * 
 * @author Philip Helger
 */
public interface ILongRunningJob extends Job
{
  /**
   * @return A description of this long running job. May not be
   *         <code>null</code>.
   */
  @Nonnull
  ISimpleMultiLingualText getJobDescription ();

  /**
   * @return The results of this job for asynchronous retrieval by the user.
   *         Never <code>null</code>.
   */
  @Nonnull
  LongRunningJobResult createResult ();
}
