/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.job;

import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.annotations.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.state.ESuccess;
import com.helger.commons.stats.IStatisticsHandlerKeyedCounter;
import com.helger.commons.stats.IStatisticsHandlerKeyedTimer;
import com.helger.commons.stats.StatisticsManager;
import com.helger.commons.timing.StopWatch;
import com.helger.schedule.job.IJobExceptionCallback;
import com.helger.schedule.longrun.ILongRunningJob;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractJob
implements Job {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractJob.class);
    private static final IStatisticsHandlerKeyedTimer s_aStatsTimer = StatisticsManager.getKeyedTimerHandler(AbstractJob.class);
    private static final IStatisticsHandlerKeyedCounter s_aStatsCounterSuccess = StatisticsManager.getKeyedCounterHandler((String)(AbstractJob.class + "$success"));
    private static final IStatisticsHandlerKeyedCounter s_aStatsCounterFailure = StatisticsManager.getKeyedCounterHandler((String)(AbstractJob.class + "$failure"));
    private static final CallbackList<IJobExceptionCallback> s_aExceptionCallbacks = new CallbackList();

    @Nonnull
    @ReturnsMutableObject(reason="design")
    public static CallbackList<IJobExceptionCallback> getExceptionCallbacks() {
        return s_aExceptionCallbacks;
    }

    @OverrideOnDemand
    protected void beforeExecute(@Nonnull JobDataMap jobDataMap) {
    }

    protected abstract void onExecute(@Nonnull JobExecutionContext var1) throws JobExecutionException;

    @OverrideOnDemand
    protected void afterExecute(@Nonnull JobDataMap jobDataMap, @Nonnull ESuccess eSuccess) {
    }

    protected static void triggerCustomExceptionHandler(@Nonnull Throwable throwable, @Nullable String string, @Nonnull Job job, boolean bl) {
        for (IJobExceptionCallback iJobExceptionCallback : AbstractJob.getExceptionCallbacks().getAllCallbacks()) {
            try {
                iJobExceptionCallback.onScheduledJobException(throwable, string, job, bl);
            }
            catch (Throwable throwable2) {
                s_aLogger.error("Exception in custom scheduled job exception handler " + iJobExceptionCallback + " for job class '" + string + "'", throwable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@Nonnull JobExecutionContext jobExecutionContext) throws JobExecutionException {
        ESuccess eSuccess = ESuccess.FAILURE;
        JobDataMap jobDataMap = new JobDataMap((Map)jobExecutionContext.getMergedJobDataMap());
        this.beforeExecute(jobDataMap);
        try {
            String string = this.getClass().getName();
            try {
                if (s_aLogger.isDebugEnabled()) {
                    s_aLogger.debug("Executing scheduled job " + string);
                }
                StopWatch stopWatch = new StopWatch(true);
                this.onExecute(jobExecutionContext);
                eSuccess = ESuccess.SUCCESS;
                s_aStatsTimer.addTime(string, stopWatch.stopAndGetMillis());
                s_aStatsCounterSuccess.increment(string);
                if (s_aLogger.isDebugEnabled()) {
                    s_aLogger.debug("Successfully finished executing scheduled job " + string);
                }
            }
            catch (Throwable throwable) {
                s_aStatsCounterFailure.increment(string);
                AbstractJob.triggerCustomExceptionHandler(throwable, string, this, this instanceof ILongRunningJob);
                if (throwable instanceof JobExecutionException) {
                    throw (JobExecutionException)throwable;
                }
                throw new JobExecutionException("Internal job execution error of " + string, throwable);
            }
        }
        finally {
            this.afterExecute(jobDataMap, eSuccess);
        }
    }
}

