/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.job;

import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.state.ESuccess;
import com.helger.schedule.job.AbstractJob;
import com.helger.web.mock.MockHttpServletRequest;
import com.helger.web.mock.MockHttpServletResponse;
import com.helger.web.mock.OfflineHttpServletRequest;
import com.helger.web.scopes.mgr.WebScopeManager;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.JobDataMap;

@ThreadSafe
public abstract class AbstractScopeAwareJob
extends AbstractJob {
    @Nonnull
    protected abstract String getApplicationScopeID(@Nonnull JobDataMap var1);

    @Nonnull
    @OverrideOnDemand
    protected MockHttpServletRequest createMockHttpServletRequest() {
        return new OfflineHttpServletRequest(WebScopeManager.getGlobalScope().getServletContext(), false);
    }

    @Nonnull
    @OverrideOnDemand
    protected MockHttpServletResponse createMockHttpServletResponse() {
        return new MockHttpServletResponse();
    }

    @OverrideOnDemand
    protected void beforeExecuteInScope(@Nonnull JobDataMap jobDataMap) {
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void beforeExecute(@Nonnull JobDataMap jobDataMap) {
        String string = this.getApplicationScopeID(jobDataMap);
        MockHttpServletRequest mockHttpServletRequest = this.createMockHttpServletRequest();
        MockHttpServletResponse mockHttpServletResponse = this.createMockHttpServletResponse();
        WebScopeManager.onRequestBegin((String)string, (HttpServletRequest)mockHttpServletRequest, (HttpServletResponse)mockHttpServletResponse);
        this.beforeExecuteInScope(jobDataMap);
    }

    @OverrideOnDemand
    protected void afterExecuteInScope(@Nonnull JobDataMap jobDataMap, @Nonnull ESuccess eSuccess) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void afterExecute(@Nonnull JobDataMap jobDataMap, @Nonnull ESuccess eSuccess) {
        try {
            this.afterExecuteInScope(jobDataMap, eSuccess);
        }
        finally {
            WebScopeManager.onRequestEnd();
        }
    }
}

