/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.longrun;

import com.helger.commons.IHasStringRepresentation;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.serialize.MicroWriter;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LongRunningJobResult
implements IHasStringRepresentation {
    private final EType m_eType;
    private final Object m_aResult;

    private LongRunningJobResult(@Nonnull EType eType, @Nonnull Object object) {
        if (eType == null) {
            throw new NullPointerException("type");
        }
        if (object == null) {
            throw new NullPointerException("result");
        }
        this.m_eType = eType;
        this.m_aResult = object;
    }

    @Nonnull
    public EType getType() {
        return this.m_eType;
    }

    @Nonnull
    public Object getResultObject() {
        return this.m_aResult;
    }

    @Nullable
    public File getResultFile() {
        return this.getType().equals((Object)EType.FILE) ? (File)this.m_aResult : null;
    }

    @Nullable
    public IMicroNode getResultXML() {
        return this.getType().equals((Object)EType.XML) ? (IMicroNode)this.m_aResult : null;
    }

    @Nullable
    public String getResultText() {
        return this.getType().equals((Object)EType.TEXT) ? (String)this.m_aResult : null;
    }

    @Nullable
    public ISimpleURL getResultLink() {
        return this.getType().equals((Object)EType.LINK) ? (ISimpleURL)this.m_aResult : null;
    }

    @Nonnull
    public String getAsString() {
        switch (this.m_eType) {
            case FILE: {
                return this.getResultFile().getAbsolutePath();
            }
            case XML: {
                return MicroWriter.getXMLString((IMicroNode)this.getResultXML());
            }
            case TEXT: {
                return this.getResultText();
            }
            case LINK: {
                return this.getResultLink().getAsString();
            }
        }
        throw new IllegalStateException("Unhandled type!");
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("type", (Enum)this.m_eType).append("result", this.m_aResult).toString();
    }

    @Nonnull
    public static LongRunningJobResult createFile(@Nonnull File file) {
        return new LongRunningJobResult(EType.FILE, file);
    }

    @Nonnull
    public static LongRunningJobResult createXML(@Nonnull IMicroNode iMicroNode) {
        return new LongRunningJobResult(EType.XML, iMicroNode);
    }

    @Nonnull
    public static LongRunningJobResult createText(@Nonnull String string) {
        return new LongRunningJobResult(EType.TEXT, string);
    }

    @Nonnull
    public static LongRunningJobResult createLink(@Nonnull ISimpleURL iSimpleURL) {
        return new LongRunningJobResult(EType.LINK, iSimpleURL);
    }

    public static enum EType implements IHasID<String>
    {
        FILE("file"),
        XML("html"),
        TEXT("text"),
        LINK("link");

        private final String m_sID;

        private EType(String string2) {
            this.m_sID = string2;
        }

        @Nonnull
        @Nonempty
        public String getID() {
            return this.m_sID;
        }

        @Nullable
        public static EType getFromIDOrNull(@Nullable String string) {
            return (EType)EnumHelper.getFromIDOrNull(EType.class, (Object)string);
        }
    }
}

