/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.quartz;

import com.helger.schedule.quartz.ESchedulerState;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SchedulerMetaData;
import org.quartz.impl.StdSchedulerFactory;

@Immutable
public final class QuartzSchedulerHelper {
    public static final boolean DEFAULT_START_AUTOMATICALLY = true;
    private static final SchedulerFactory s_aSchedulerFactory = new StdSchedulerFactory();

    private QuartzSchedulerHelper() {
    }

    @Nonnull
    public static Scheduler getScheduler() {
        return QuartzSchedulerHelper.getScheduler(true);
    }

    @Nonnull
    public static Scheduler getScheduler(boolean bl) {
        try {
            Scheduler scheduler = s_aSchedulerFactory.getScheduler();
            if (bl && !scheduler.isStarted()) {
                scheduler.start();
            }
            return scheduler;
        }
        catch (SchedulerException schedulerException) {
            throw new IllegalStateException("Failed to create and start scheduler!", schedulerException);
        }
    }

    @Nonnull
    public static SchedulerMetaData getSchedulerMetaData() {
        try {
            return s_aSchedulerFactory.getScheduler().getMetaData();
        }
        catch (SchedulerException schedulerException) {
            throw new IllegalStateException("Failed to get scheduler metadata", schedulerException);
        }
    }

    @Nonnull
    public static ESchedulerState getSchedulerState() {
        try {
            Scheduler scheduler = s_aSchedulerFactory.getScheduler();
            if (scheduler.isStarted()) {
                return ESchedulerState.STARTED;
            }
            if (scheduler.isInStandbyMode()) {
                return ESchedulerState.STANDBY;
            }
            if (scheduler.isShutdown()) {
                return ESchedulerState.SHUTDOWN;
            }
        }
        catch (SchedulerException schedulerException) {
            throw new IllegalStateException("Error retrieving scheduler state!", schedulerException);
        }
        throw new IllegalStateException("Unknown scheduler state!");
    }
}

