/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.quartz.listener;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.lang.CGStringHelper;
import javax.annotation.Nonnull;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingJobListener
implements JobListener {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingJobListener.class);

    @Nonnull
    @Nonempty
    public String getName() {
        return "LoggingJobListener";
    }

    @Nonnull
    @Nonempty
    protected String getJobName(@Nonnull JobExecutionContext jobExecutionContext) {
        return CGStringHelper.getClassLocalName((Class)jobExecutionContext.getJobDetail().getJobClass());
    }

    public void jobToBeExecuted(@Nonnull JobExecutionContext jobExecutionContext) {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Job to be executed: " + this.getJobName(jobExecutionContext));
        }
    }

    public void jobExecutionVetoed(@Nonnull JobExecutionContext jobExecutionContext) {
        s_aLogger.warn("Job execution vetoed by trigger listener: " + this.getJobName(jobExecutionContext));
    }

    public void jobWasExecuted(@Nonnull JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        Object object = jobExecutionContext.getResult();
        long l = jobExecutionContext.getJobRunTime();
        String string = "Job was executed: " + this.getJobName(jobExecutionContext) + (object == null ? "" : "; result=" + object) + "; duration=" + l + "ms";
        if (jobExecutionException == null) {
            s_aLogger.info(string);
        } else {
            s_aLogger.error(string, (Throwable)jobExecutionException);
        }
    }
}

